/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block;

import java.util.Random;
import org.ejml.alg.block.BlockMultiplication;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.D1Submatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.ConvertMatrixType;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.RandomMatrices;

public class BlockMatrixOps {
    public static void convert(DenseMatrix64F denseMatrix64F, BlockMatrix64F blockMatrix64F) {
        ConvertMatrixType.convert(denseMatrix64F, blockMatrix64F);
    }

    public static void convertRowToBlock(int n, int n2, int n3, double[] dArray, double[] dArray2) {
        int n4 = Math.min(n3, n) * n2;
        if (dArray2.length < n4) {
            throw new IllegalArgumentException("tmp must be at least " + n4 + " long ");
        }
        for (int i = 0; i < n; i += n3) {
            int n5 = Math.min(n3, n - i);
            System.arraycopy(dArray, i * n2, dArray2, 0, n5 * n2);
            for (int j = 0; j < n2; j += n3) {
                int n6 = Math.min(n3, n2 - j);
                int n7 = i * n2 + n5 * j;
                int n8 = j;
                for (int k = 0; k < n5; ++k) {
                    System.arraycopy(dArray2, n8, dArray, n7, n6);
                    n7 += n6;
                    n8 += n2;
                }
            }
        }
    }

    public static DenseMatrix64F convert(BlockMatrix64F blockMatrix64F, DenseMatrix64F denseMatrix64F) {
        return ConvertMatrixType.convert(blockMatrix64F, denseMatrix64F);
    }

    public static void convertBlockToRow(int n, int n2, int n3, double[] dArray, double[] dArray2) {
        int n4 = Math.min(n3, n) * n2;
        if (dArray2.length < n4) {
            throw new IllegalArgumentException("tmp must be at least " + n4 + " long and not " + dArray2.length);
        }
        for (int i = 0; i < n; i += n3) {
            int n5 = Math.min(n3, n - i);
            System.arraycopy(dArray, i * n2, dArray2, 0, n5 * n2);
            for (int j = 0; j < n2; j += n3) {
                int n6 = Math.min(n3, n2 - j);
                int n7 = n5 * j;
                int n8 = i * n2 + j;
                for (int k = 0; k < n5; ++k) {
                    System.arraycopy(dArray2, n7, dArray, n8, n6);
                    n7 += n6;
                    n8 += n2;
                }
            }
        }
    }

    public static void convertTranSrc(DenseMatrix64F denseMatrix64F, BlockMatrix64F blockMatrix64F) {
        if (denseMatrix64F.numRows != blockMatrix64F.numCols || denseMatrix64F.numCols != blockMatrix64F.numRows) {
            throw new IllegalArgumentException("Incompatible matrix shapes.");
        }
        for (int i = 0; i < blockMatrix64F.numRows; i += blockMatrix64F.blockLength) {
            int n = Math.min(blockMatrix64F.blockLength, blockMatrix64F.numRows - i);
            for (int j = 0; j < blockMatrix64F.numCols; j += blockMatrix64F.blockLength) {
                int n2 = Math.min(blockMatrix64F.blockLength, blockMatrix64F.numCols - j);
                int n3 = i * blockMatrix64F.numCols + n * j;
                int n4 = j * denseMatrix64F.numCols + i;
                for (int k = 0; k < n2; ++k) {
                    int n5 = n4 + k * denseMatrix64F.numCols;
                    int n6 = n3 + k;
                    int n7 = 0;
                    while (n7 < n) {
                        blockMatrix64F.data[n6] = denseMatrix64F.data[n5++];
                        ++n7;
                        n6 += n2;
                    }
                }
            }
        }
    }

    public static void mult(BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2, BlockMatrix64F blockMatrix64F3) {
        if (blockMatrix64F.numCols != blockMatrix64F2.numRows) {
            throw new IllegalArgumentException("Columns in A are incompatible with rows in B");
        }
        if (blockMatrix64F.numRows != blockMatrix64F3.numRows) {
            throw new IllegalArgumentException("Rows in A are incompatible with rows in C");
        }
        if (blockMatrix64F2.numCols != blockMatrix64F3.numCols) {
            throw new IllegalArgumentException("Columns in B are incompatible with columns in C");
        }
        if (blockMatrix64F.blockLength != blockMatrix64F2.blockLength || blockMatrix64F.blockLength != blockMatrix64F3.blockLength) {
            throw new IllegalArgumentException("Block lengths are not all the same.");
        }
        int n = blockMatrix64F.blockLength;
        D1Submatrix64F d1Submatrix64F = new D1Submatrix64F(blockMatrix64F, 0, blockMatrix64F.numRows, 0, blockMatrix64F.numCols);
        D1Submatrix64F d1Submatrix64F2 = new D1Submatrix64F(blockMatrix64F2, 0, blockMatrix64F2.numRows, 0, blockMatrix64F2.numCols);
        D1Submatrix64F d1Submatrix64F3 = new D1Submatrix64F(blockMatrix64F3, 0, blockMatrix64F3.numRows, 0, blockMatrix64F3.numCols);
        BlockMultiplication.mult(n, d1Submatrix64F, d1Submatrix64F2, d1Submatrix64F3);
    }

    public static void multTransA(BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2, BlockMatrix64F blockMatrix64F3) {
        if (blockMatrix64F.numRows != blockMatrix64F2.numRows) {
            throw new IllegalArgumentException("Rows in A are incompatible with rows in B");
        }
        if (blockMatrix64F.numCols != blockMatrix64F3.numRows) {
            throw new IllegalArgumentException("Columns in A are incompatible with rows in C");
        }
        if (blockMatrix64F2.numCols != blockMatrix64F3.numCols) {
            throw new IllegalArgumentException("Columns in B are incompatible with columns in C");
        }
        if (blockMatrix64F.blockLength != blockMatrix64F2.blockLength || blockMatrix64F.blockLength != blockMatrix64F3.blockLength) {
            throw new IllegalArgumentException("Block lengths are not all the same.");
        }
        int n = blockMatrix64F.blockLength;
        D1Submatrix64F d1Submatrix64F = new D1Submatrix64F(blockMatrix64F, 0, blockMatrix64F.numRows, 0, blockMatrix64F.numCols);
        D1Submatrix64F d1Submatrix64F2 = new D1Submatrix64F(blockMatrix64F2, 0, blockMatrix64F2.numRows, 0, blockMatrix64F2.numCols);
        D1Submatrix64F d1Submatrix64F3 = new D1Submatrix64F(blockMatrix64F3, 0, blockMatrix64F3.numRows, 0, blockMatrix64F3.numCols);
        BlockMultiplication.multTransA(n, d1Submatrix64F, d1Submatrix64F2, d1Submatrix64F3);
    }

    public static void multTransB(BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2, BlockMatrix64F blockMatrix64F3) {
        if (blockMatrix64F.numCols != blockMatrix64F2.numCols) {
            throw new IllegalArgumentException("Columns in A are incompatible with columns in B");
        }
        if (blockMatrix64F.numRows != blockMatrix64F3.numRows) {
            throw new IllegalArgumentException("Rows in A are incompatible with rows in C");
        }
        if (blockMatrix64F2.numRows != blockMatrix64F3.numCols) {
            throw new IllegalArgumentException("Rows in B are incompatible with columns in C");
        }
        if (blockMatrix64F.blockLength != blockMatrix64F2.blockLength || blockMatrix64F.blockLength != blockMatrix64F3.blockLength) {
            throw new IllegalArgumentException("Block lengths are not all the same.");
        }
        int n = blockMatrix64F.blockLength;
        D1Submatrix64F d1Submatrix64F = new D1Submatrix64F(blockMatrix64F, 0, blockMatrix64F.numRows, 0, blockMatrix64F.numCols);
        D1Submatrix64F d1Submatrix64F2 = new D1Submatrix64F(blockMatrix64F2, 0, blockMatrix64F2.numRows, 0, blockMatrix64F2.numCols);
        D1Submatrix64F d1Submatrix64F3 = new D1Submatrix64F(blockMatrix64F3, 0, blockMatrix64F3.numRows, 0, blockMatrix64F3.numCols);
        BlockMultiplication.multTransB(n, d1Submatrix64F, d1Submatrix64F2, d1Submatrix64F3);
    }

    public static BlockMatrix64F transpose(BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2) {
        if (blockMatrix64F2 != null) {
            if (blockMatrix64F.numRows != blockMatrix64F2.numCols || blockMatrix64F.numCols != blockMatrix64F2.numRows) {
                throw new IllegalArgumentException("Incompatible dimensions.");
            }
            if (blockMatrix64F.blockLength != blockMatrix64F2.blockLength) {
                throw new IllegalArgumentException("Incompatible block size.");
            }
        } else {
            blockMatrix64F2 = new BlockMatrix64F(blockMatrix64F.numCols, blockMatrix64F.numRows, blockMatrix64F.blockLength);
        }
        for (int i = 0; i < blockMatrix64F.numRows; i += blockMatrix64F.blockLength) {
            int n = Math.min(blockMatrix64F.blockLength, blockMatrix64F.numRows - i);
            for (int j = 0; j < blockMatrix64F.numCols; j += blockMatrix64F.blockLength) {
                int n2 = Math.min(blockMatrix64F.blockLength, blockMatrix64F.numCols - j);
                int n3 = i * blockMatrix64F.numCols + n * j;
                int n4 = j * blockMatrix64F2.numCols + n2 * i;
                BlockMatrixOps.transposeBlock(blockMatrix64F, blockMatrix64F2, n3, n4, n2, n);
            }
        }
        return blockMatrix64F2;
    }

    private static void transposeBlock(BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6 = n2 + i;
            int n7 = n5 + n3;
            for (n5 = n + n3 * i; n5 < n7; ++n5) {
                blockMatrix64F2.data[n6] = blockMatrix64F.data[n5];
                n6 += n4;
            }
        }
    }

    public static BlockMatrix64F createRandom(int n, int n2, double d, double d2, Random random) {
        BlockMatrix64F blockMatrix64F = new BlockMatrix64F(n, n2);
        RandomMatrices.setRandom(blockMatrix64F, d, d2, random);
        return blockMatrix64F;
    }

    public static BlockMatrix64F createRandom(int n, int n2, double d, double d2, Random random, int n3) {
        BlockMatrix64F blockMatrix64F = new BlockMatrix64F(n, n2, n3);
        RandomMatrices.setRandom(blockMatrix64F, d, d2, random);
        return blockMatrix64F;
    }

    public static BlockMatrix64F convert(DenseMatrix64F denseMatrix64F, int n) {
        BlockMatrix64F blockMatrix64F = new BlockMatrix64F(denseMatrix64F.numRows, denseMatrix64F.numCols, n);
        BlockMatrixOps.convert(denseMatrix64F, blockMatrix64F);
        return blockMatrix64F;
    }

    public static BlockMatrix64F convert(DenseMatrix64F denseMatrix64F) {
        BlockMatrix64F blockMatrix64F = new BlockMatrix64F(denseMatrix64F.numRows, denseMatrix64F.numCols);
        BlockMatrixOps.convert(denseMatrix64F, blockMatrix64F);
        return blockMatrix64F;
    }

    public static boolean isEquals(BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2) {
        if (blockMatrix64F.blockLength != blockMatrix64F2.blockLength) {
            return false;
        }
        return MatrixFeatures.isEquals(blockMatrix64F, blockMatrix64F2);
    }

    public static boolean isEquals(BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2, double d) {
        if (blockMatrix64F.blockLength != blockMatrix64F2.blockLength) {
            return false;
        }
        return MatrixFeatures.isEquals(blockMatrix64F, blockMatrix64F2, d);
    }

    public static void zeroTriangle(boolean bl, BlockMatrix64F blockMatrix64F) {
        int n = blockMatrix64F.blockLength;
        if (bl) {
            for (int i = 0; i < blockMatrix64F.numRows; i += n) {
                int n2 = Math.min(n, blockMatrix64F.numRows - i);
                for (int j = i; j < blockMatrix64F.numCols; j += n) {
                    int n3;
                    int n4;
                    int n5 = Math.min(n, blockMatrix64F.numCols - j);
                    int n6 = i * blockMatrix64F.numCols + n2 * j;
                    if (j == i) {
                        for (n4 = 0; n4 < n2; ++n4) {
                            for (n3 = n4 + 1; n3 < n5; ++n3) {
                                blockMatrix64F.data[n6 + n5 * n4 + n3] = 0.0;
                            }
                        }
                        continue;
                    }
                    for (n4 = 0; n4 < n2; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            blockMatrix64F.data[n6 + n5 * n4 + n3] = 0.0;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < blockMatrix64F.numRows; i += n) {
                int n7 = Math.min(n, blockMatrix64F.numRows - i);
                for (int j = 0; j <= i; j += n) {
                    int n8;
                    int n9;
                    int n10 = Math.min(n, blockMatrix64F.numCols - j);
                    int n11 = i * blockMatrix64F.numCols + n7 * j;
                    if (j == i) {
                        for (n9 = 0; n9 < n7; ++n9) {
                            n8 = Math.min(n9, n10);
                            for (int k = 0; k < n8; ++k) {
                                blockMatrix64F.data[n11 + n10 * n9 + k] = 0.0;
                            }
                        }
                        continue;
                    }
                    for (n9 = 0; n9 < n7; ++n9) {
                        for (n8 = 0; n8 < n10; ++n8) {
                            blockMatrix64F.data[n11 + n10 * n9 + n8] = 0.0;
                        }
                    }
                }
            }
        }
    }

    public static void copyTriangle(boolean bl, BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2) {
        if (blockMatrix64F.blockLength != blockMatrix64F2.blockLength) {
            throw new IllegalArgumentException("Block size is different");
        }
        if (blockMatrix64F.numRows < blockMatrix64F2.numRows) {
            throw new IllegalArgumentException("The src has fewer rows than dst");
        }
        if (blockMatrix64F.numCols < blockMatrix64F2.numCols) {
            throw new IllegalArgumentException("The src has fewer columns than dst");
        }
        int n = blockMatrix64F.blockLength;
        int n2 = Math.min(blockMatrix64F.numRows, blockMatrix64F2.numRows);
        int n3 = Math.min(blockMatrix64F.numCols, blockMatrix64F2.numCols);
        if (bl) {
            for (int i = 0; i < n2; i += n) {
                int n4 = Math.min(n, blockMatrix64F.numRows - i);
                int n5 = Math.min(n, blockMatrix64F2.numRows - i);
                for (int j = i; j < n3; j += n) {
                    int n6;
                    int n7 = Math.min(n, blockMatrix64F.numCols - j);
                    int n8 = Math.min(n, blockMatrix64F2.numCols - j);
                    int n9 = i * blockMatrix64F.numCols + n4 * j;
                    int n10 = i * blockMatrix64F2.numCols + n5 * j;
                    if (j == i) {
                        for (n6 = 0; n6 < n5; ++n6) {
                            for (int k = n6; k < n8; ++k) {
                                blockMatrix64F2.data[n10 + n8 * n6 + k] = blockMatrix64F.data[n9 + n7 * n6 + k];
                            }
                        }
                        continue;
                    }
                    for (n6 = 0; n6 < n5; ++n6) {
                        System.arraycopy(blockMatrix64F.data, n9 + n7 * n6, blockMatrix64F2.data, n10 + n8 * n6, n8);
                    }
                }
            }
        } else {
            for (int i = 0; i < n2; i += n) {
                int n11 = Math.min(n, blockMatrix64F.numRows - i);
                int n12 = Math.min(n, blockMatrix64F2.numRows - i);
                for (int j = 0; j <= i; j += n) {
                    int n13;
                    int n14 = Math.min(n, blockMatrix64F.numCols - j);
                    int n15 = Math.min(n, blockMatrix64F2.numCols - j);
                    int n16 = i * blockMatrix64F.numCols + n11 * j;
                    int n17 = i * blockMatrix64F2.numCols + n12 * j;
                    if (j == i) {
                        for (n13 = 0; n13 < n12; ++n13) {
                            int n18 = Math.min(n13 + 1, n15);
                            for (int k = 0; k < n18; ++k) {
                                blockMatrix64F2.data[n17 + n15 * n13 + k] = blockMatrix64F.data[n16 + n14 * n13 + k];
                            }
                        }
                        continue;
                    }
                    for (n13 = 0; n13 < n12; ++n13) {
                        System.arraycopy(blockMatrix64F.data, n16 + n14 * n13, blockMatrix64F2.data, n17 + n15 * n13, n15);
                    }
                }
            }
        }
    }

    public static void set(BlockMatrix64F blockMatrix64F, double d) {
        CommonOps.fill(blockMatrix64F, d);
    }

    public static void setIdentity(BlockMatrix64F blockMatrix64F) {
        int n = Math.min(blockMatrix64F.numRows, blockMatrix64F.numCols);
        CommonOps.fill(blockMatrix64F, 0.0);
        int n2 = blockMatrix64F.blockLength;
        for (int i = 0; i < n; i += n2) {
            int n3 = Math.min(n2, blockMatrix64F.numRows - i);
            int n4 = Math.min(n2, blockMatrix64F.numCols - i);
            int n5 = i * blockMatrix64F.numCols + n3 * i;
            int n6 = Math.min(n3, n4);
            for (int j = 0; j < n6; ++j) {
                blockMatrix64F.data[n5 + j * n4 + j] = 1.0;
            }
        }
    }

    public static BlockMatrix64F identity(int n, int n2, int n3) {
        BlockMatrix64F blockMatrix64F = new BlockMatrix64F(n, n2, n3);
        int n4 = Math.min(n, n2);
        for (int i = 0; i < n4; i += n3) {
            int n5 = Math.min(n3, blockMatrix64F.numRows - i);
            int n6 = Math.min(n3, blockMatrix64F.numCols - i);
            int n7 = i * blockMatrix64F.numCols + n5 * i;
            int n8 = Math.min(n5, n6);
            for (int j = 0; j < n8; ++j) {
                blockMatrix64F.data[n7 + j * n6 + j] = 1.0;
            }
        }
        return blockMatrix64F;
    }

    public static void checkIdenticalShape(BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2) {
        if (blockMatrix64F.blockLength != blockMatrix64F2.blockLength) {
            throw new IllegalArgumentException("Block size is different");
        }
        if (blockMatrix64F.numRows != blockMatrix64F2.numRows) {
            throw new IllegalArgumentException("Number of rows is different");
        }
        if (blockMatrix64F.numCols != blockMatrix64F2.numCols) {
            throw new IllegalArgumentException("NUmber of columns is different");
        }
    }

    public static void extractAligned(BlockMatrix64F blockMatrix64F, BlockMatrix64F blockMatrix64F2) {
        if (blockMatrix64F.blockLength != blockMatrix64F2.blockLength) {
            throw new IllegalArgumentException("Block size is different");
        }
        if (blockMatrix64F.numRows < blockMatrix64F2.numRows) {
            throw new IllegalArgumentException("The src has fewer rows than dst");
        }
        if (blockMatrix64F.numCols < blockMatrix64F2.numCols) {
            throw new IllegalArgumentException("The src has fewer columns than dst");
        }
        int n = blockMatrix64F.blockLength;
        int n2 = Math.min(blockMatrix64F.numRows, blockMatrix64F2.numRows);
        int n3 = Math.min(blockMatrix64F.numCols, blockMatrix64F2.numCols);
        for (int i = 0; i < n2; i += n) {
            int n4 = Math.min(n, blockMatrix64F.numRows - i);
            int n5 = Math.min(n, blockMatrix64F2.numRows - i);
            for (int j = 0; j < n3; j += n) {
                int n6 = Math.min(n, blockMatrix64F.numCols - j);
                int n7 = Math.min(n, blockMatrix64F2.numCols - j);
                int n8 = i * blockMatrix64F.numCols + n4 * j;
                int n9 = i * blockMatrix64F2.numCols + n5 * j;
                for (int k = 0; k < n5; ++k) {
                    System.arraycopy(blockMatrix64F.data, n8 + n6 * k, blockMatrix64F2.data, n9 + n7 * k, n7);
                }
            }
        }
    }

    public static boolean blockAligned(int n, D1Submatrix64F d1Submatrix64F) {
        if (d1Submatrix64F.col0 % n != 0) {
            return false;
        }
        if (d1Submatrix64F.row0 % n != 0) {
            return false;
        }
        if (d1Submatrix64F.col1 % n != 0 && d1Submatrix64F.col1 != d1Submatrix64F.original.numCols) {
            return false;
        }
        return d1Submatrix64F.row1 % n == 0 || d1Submatrix64F.row1 == d1Submatrix64F.original.numRows;
    }
}

