/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.io.image.ConvertRaster;
import boofcv.struct.image.GrayF;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.reflect.Array;
import java.security.AccessControlException;
import javax.swing.JComponent;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.IntegerInterleavedRaster;
import sun.awt.image.ShortInterleavedRaster;
import sun.awt.image.SunWritableRaster;

public class ConvertBufferedImage {
    public static BufferedImage stripAlphaChannel(BufferedImage image) {
        int numBands = image.getRaster().getNumBands();
        if (numBands == 4) {
            BufferedImage output = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            output.createGraphics().drawImage((Image)image, 0, 0, null);
            return output;
        }
        return image;
    }

    public static InterleavedU8 extractInterleavedU8(BufferedImage img) {
        if (img.getRaster() instanceof ByteInterleavedRaster && img.getType() != 13) {
            ByteInterleavedRaster raster = (ByteInterleavedRaster)img.getRaster();
            InterleavedU8 ret = new InterleavedU8();
            ret.width = img.getWidth();
            ret.height = img.getHeight();
            ret.stride = raster.getScanlineStride();
            ret.startIndex = raster.getDataOffset(0) - raster.getPixelStride() + 1;
            ret.setNumBands(raster.getNumBands());
            ret.data = raster.getDataStorage();
            return ret;
        }
        throw new IllegalArgumentException("Buffered image does not have an interleaved byte raster");
    }

    public static GrayU8 extractGrayU8(BufferedImage img) {
        if (img.getRaster() instanceof ByteInterleavedRaster && img.getType() != 13) {
            ByteInterleavedRaster raster = (ByteInterleavedRaster)img.getRaster();
            if (raster.getNumBands() != 1) {
                throw new IllegalArgumentException("Input image has more than one channel");
            }
            GrayU8 ret = new GrayU8();
            ret.width = img.getWidth();
            ret.height = img.getHeight();
            ret.startIndex = raster.getDataOffset(0);
            ret.stride = raster.getScanlineStride();
            ret.data = raster.getDataStorage();
            return ret;
        }
        throw new IllegalArgumentException("Buffered image does not have a gray scale byte raster");
    }

    public static BufferedImage extractBuffered(InterleavedU8 img) {
        ComponentColorModel colorModel;
        ColorSpace cs;
        if (img.isSubimage()) {
            throw new IllegalArgumentException("Sub-images are not supported for this operation");
        }
        int width = img.width;
        int height = img.height;
        int numBands = img.numBands;
        DataBufferByte bufferByte = new DataBufferByte(img.data, width * height * numBands, 0);
        int[] bOffs = null;
        if (numBands == 3) {
            cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8};
            bOffs = new int[]{2, 1, 0};
            colorModel = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        } else if (numBands == 1) {
            cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{8};
            bOffs = new int[]{0};
            colorModel = new ComponentColorModel(cs, nBits, false, true, 1, 0);
        } else {
            throw new IllegalArgumentException("Only 1 or 3 bands supported");
        }
        WritableRaster raster = Raster.createInterleavedRaster(bufferByte, width, height, img.stride, numBands, bOffs, new Point(0, 0));
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage extractBuffered(GrayU8 img) {
        if (img.isSubimage()) {
            throw new IllegalArgumentException("Sub-images are not supported for this operation");
        }
        int width = img.width;
        int height = img.height;
        DataBufferByte bufferByte = new DataBufferByte(img.data, width * height, 0);
        int[] bOffs = new int[]{0};
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] nBits = new int[]{8};
        ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, false, true, 1, 0);
        WritableRaster raster = Raster.createInterleavedRaster(bufferByte, width, height, img.stride, 1, bOffs, new Point(0, 0));
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static <T extends ImageBase> void convertFrom(BufferedImage src, T dst, boolean orderRgb) {
        if (dst instanceof ImageGray) {
            ImageGray sb = (ImageGray)dst;
            ConvertBufferedImage.convertFromSingle(src, sb, sb.getClass());
        } else if (dst instanceof Planar) {
            Planar ms = (Planar)dst;
            ConvertBufferedImage.convertFromMulti(src, ms, orderRgb, ms.getBandType());
        } else if (dst instanceof ImageInterleaved) {
            ConvertBufferedImage.convertFromInterleaved(src, (ImageInterleaved)dst, orderRgb);
        } else {
            throw new IllegalArgumentException("Unknown type " + dst.getClass().getSimpleName());
        }
    }

    public static <T extends ImageBase> T convertFrom(BufferedImage src, boolean orderRgb, ImageType<T> imageType) {
        T out = imageType.createImage(src.getWidth(), src.getHeight());
        switch (imageType.getFamily()) {
            case GRAY: {
                ConvertBufferedImage.convertFromSingle(src, (ImageGray)out, imageType.getImageClass());
                break;
            }
            case PLANAR: {
                ConvertBufferedImage.convertFromMulti(src, (Planar)out, orderRgb, imageType.getImageClass());
                break;
            }
            case INTERLEAVED: {
                ConvertBufferedImage.convertFromInterleaved(src, (ImageInterleaved)out, orderRgb);
                break;
            }
            default: {
                throw new RuntimeException("Not supported yet");
            }
        }
        return out;
    }

    public static <T extends ImageBase> T convertFrom(BufferedImage src, boolean orderRgb, T output) {
        ImageType imageType = output.getImageType();
        switch (imageType.getFamily()) {
            case GRAY: {
                ConvertBufferedImage.convertFromSingle(src, (ImageGray)output, imageType.getImageClass());
                break;
            }
            case PLANAR: {
                ConvertBufferedImage.convertFromMulti(src, (Planar)output, orderRgb, imageType.getImageClass());
                break;
            }
            case INTERLEAVED: {
                ConvertBufferedImage.convertFromInterleaved(src, (ImageInterleaved)output, orderRgb);
                break;
            }
            default: {
                throw new RuntimeException("Not supported yet");
            }
        }
        return output;
    }

    public static <T extends ImageGray> T convertFromSingle(BufferedImage src, T dst, Class<T> type) {
        if (type == GrayU8.class) {
            return (T)ConvertBufferedImage.convertFrom(src, (GrayU8)dst);
        }
        if (GrayI16.class.isAssignableFrom(type)) {
            return (T)ConvertBufferedImage.convertFrom(src, (GrayI16)dst, type);
        }
        if (type == GrayF32.class) {
            return (T)ConvertBufferedImage.convertFrom(src, (GrayF32)dst);
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static GrayU8 convertFrom(BufferedImage src, GrayU8 dst) {
        if (dst != null) {
            if (src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight()) {
                throw new IllegalArgumentException("image dimension are different");
            }
        } else {
            dst = new GrayU8(src.getWidth(), src.getHeight());
        }
        try {
            if (src.getRaster() instanceof ByteInterleavedRaster) {
                if (src.getType() != 13) {
                    ConvertRaster.bufferedToGray((ByteInterleavedRaster)src.getRaster(), dst);
                } else {
                    ConvertRaster.bufferedToGray(src, dst);
                }
            } else if (src.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.bufferedToGray((IntegerInterleavedRaster)src.getRaster(), dst);
            } else if (src.getRaster().getClass() == SunWritableRaster.class) {
                ConvertRaster.bufferedToGray((SunWritableRaster)src.getRaster(), dst);
            } else {
                ConvertRaster.bufferedToGray(src, dst);
            }
        }
        catch (AccessControlException e) {
            ConvertRaster.bufferedToGray(src, dst);
        }
        return dst;
    }

    public static <T extends GrayI16> T convertFrom(BufferedImage src, T dst, Class<T> type) {
        if (dst != null) {
            if (src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight()) {
                throw new IllegalArgumentException("image dimension are different");
            }
        } else {
            dst = (GrayI16)GeneralizedImageOps.createSingleBand(type, src.getWidth(), src.getHeight());
        }
        try {
            if (src.getRaster() instanceof ShortInterleavedRaster) {
                ConvertRaster.bufferedToGray((ShortInterleavedRaster)src.getRaster(), dst);
                return dst;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        ConvertRaster.bufferedToGray(src, dst);
        return dst;
    }

    public static GrayF32 convertFrom(BufferedImage src, GrayF32 dst) {
        if (dst != null) {
            if (src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight()) {
                String difference = "src = " + src.getWidth() + "x" + src.getHeight() + "  dst = " + dst.getWidth() + "x" + dst.getHeight();
                throw new IllegalArgumentException("image dimension are different. " + difference);
            }
        } else {
            dst = new GrayF32(src.getWidth(), src.getHeight());
        }
        try {
            if (src.getRaster() instanceof ByteInterleavedRaster) {
                if (src.getType() != 13) {
                    ConvertRaster.bufferedToGray((ByteInterleavedRaster)src.getRaster(), dst);
                } else {
                    ConvertRaster.bufferedToGray(src, dst);
                }
            } else if (src.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.bufferedToGray((IntegerInterleavedRaster)src.getRaster(), dst);
            } else if (src.getRaster().getClass() == SunWritableRaster.class) {
                ConvertRaster.bufferedToGray((SunWritableRaster)src.getRaster(), dst);
            } else {
                ConvertRaster.bufferedToGray(src, dst);
            }
        }
        catch (AccessControlException e) {
            ConvertRaster.bufferedToGray(src, dst);
        }
        return dst;
    }

    public static <T extends ImageGray> Planar<T> convertFromMulti(BufferedImage src, Planar<T> dst, boolean orderRgb, Class<T> type) {
        block26: {
            if (src == null) {
                throw new IllegalArgumentException("src is null!");
            }
            if (dst != null && (src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight())) {
                throw new IllegalArgumentException("image dimension are different");
            }
            try {
                WritableRaster raster = src.getRaster();
                int numBands = src.getType() == 13 ? 3 : raster.getNumBands();
                if (dst == null) {
                    dst = new Planar<T>(type, src.getWidth(), src.getHeight(), numBands);
                } else if (dst.getNumBands() != numBands) {
                    throw new IllegalArgumentException("Expected " + numBands + " bands in dst not " + dst.getNumBands());
                }
                if (type == GrayU8.class) {
                    if (src.getRaster() instanceof ByteInterleavedRaster && src.getType() != 13) {
                        if (src.getType() == 10) {
                            for (int i = 0; i < dst.getNumBands(); ++i) {
                                ConvertRaster.bufferedToGray(src, dst.getBand(i));
                            }
                        } else {
                            ConvertRaster.bufferedToMulti_U8((ByteInterleavedRaster)src.getRaster(), dst);
                        }
                    } else if (src.getRaster() instanceof IntegerInterleavedRaster) {
                        ConvertRaster.bufferedToMulti_U8((IntegerInterleavedRaster)src.getRaster(), dst);
                    } else {
                        ConvertRaster.bufferedToMulti_U8(src, dst);
                    }
                    break block26;
                }
                if (type == GrayF32.class) {
                    if (src.getRaster() instanceof ByteInterleavedRaster && src.getType() != 13) {
                        if (src.getType() == 10) {
                            for (int i = 0; i < dst.getNumBands(); ++i) {
                                ConvertRaster.bufferedToGray(src, (GrayF32)((Object)dst.getBand(i)));
                            }
                        } else {
                            ConvertRaster.bufferedToMulti_F32((ByteInterleavedRaster)src.getRaster(), dst);
                        }
                    } else if (src.getRaster() instanceof IntegerInterleavedRaster) {
                        ConvertRaster.bufferedToMulti_F32((IntegerInterleavedRaster)src.getRaster(), dst);
                    } else {
                        ConvertRaster.bufferedToMulti_F32(src, dst);
                    }
                    break block26;
                }
                throw new IllegalArgumentException("Band type not supported yet");
            }
            catch (AccessControlException e) {
                if (dst == null) {
                    dst = new Planar<T>(type, src.getWidth(), src.getHeight(), 3);
                }
                if (type == GrayU8.class) {
                    ConvertRaster.bufferedToMulti_U8(src, dst);
                }
                if (type != GrayF32.class) break block26;
                ConvertRaster.bufferedToMulti_F32(src, dst);
            }
        }
        if (orderRgb) {
            ConvertBufferedImage.orderBandsIntoRGB(dst, src);
        }
        return dst;
    }

    public static void convertFromInterleaved(BufferedImage src, ImageInterleaved dst, boolean orderRgb) {
        block30: {
            if (src == null) {
                throw new IllegalArgumentException("src is null!");
            }
            if (src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight()) {
                throw new IllegalArgumentException("image dimension are different");
            }
            try {
                WritableRaster raster = src.getRaster();
                int numBands = src.getType() == 13 ? 3 : raster.getNumBands();
                if (dst.getNumBands() != numBands) {
                    throw new IllegalArgumentException("Expected " + numBands + " bands in dst not " + dst.getNumBands());
                }
                if (dst instanceof InterleavedU8) {
                    if (src.getRaster() instanceof ByteInterleavedRaster) {
                        if (src.getType() != 13) {
                            if (src.getType() == 10) {
                                ConvertRaster.bufferedToGray(src, (InterleavedU8)dst);
                            } else {
                                ConvertRaster.bufferedToInterleaved((ByteInterleavedRaster)src.getRaster(), (InterleavedU8)dst);
                            }
                        } else {
                            ConvertRaster.bufferedToInterleaved(src, (InterleavedU8)dst);
                        }
                    } else if (src.getRaster() instanceof IntegerInterleavedRaster) {
                        ConvertRaster.bufferedToInterleaved((IntegerInterleavedRaster)src.getRaster(), (InterleavedU8)dst);
                    } else if (src.getRaster() instanceof SunWritableRaster) {
                        ConvertRaster.bufferedToInterleaved((SunWritableRaster)src.getRaster(), (InterleavedU8)dst);
                    } else {
                        ConvertRaster.bufferedToInterleaved(src, (InterleavedU8)dst);
                    }
                    break block30;
                }
                if (dst instanceof InterleavedF32) {
                    if (src.getRaster() instanceof ByteInterleavedRaster) {
                        if (src.getType() != 13) {
                            if (src.getType() == 10) {
                                ConvertRaster.bufferedToGray(src, (InterleavedF32)dst);
                            } else {
                                ConvertRaster.bufferedToInterleaved((ByteInterleavedRaster)src.getRaster(), (InterleavedF32)dst);
                            }
                        } else {
                            ConvertRaster.bufferedToInterleaved(src, (InterleavedF32)dst);
                        }
                    } else if (src.getRaster() instanceof IntegerInterleavedRaster) {
                        ConvertRaster.bufferedToInterleaved((IntegerInterleavedRaster)src.getRaster(), (InterleavedF32)dst);
                    } else if (src.getRaster() instanceof SunWritableRaster) {
                        ConvertRaster.bufferedToInterleaved((SunWritableRaster)src.getRaster(), (InterleavedF32)dst);
                    } else {
                        ConvertRaster.bufferedToInterleaved(src, (InterleavedF32)dst);
                    }
                    break block30;
                }
                throw new IllegalArgumentException("Data type not supported yet");
            }
            catch (AccessControlException e) {
                if (dst instanceof InterleavedU8) {
                    ConvertRaster.bufferedToInterleaved(src, (InterleavedU8)dst);
                }
                if (dst instanceof InterleavedF32) {
                    ConvertRaster.bufferedToInterleaved(src, (InterleavedF32)dst);
                }
                throw new IllegalArgumentException("Unsupported dst image type");
            }
        }
        if (orderRgb) {
            ConvertBufferedImage.orderBandsIntoRGB(dst, src);
        }
    }

    public static BufferedImage convertTo(ImageBase src, BufferedImage dst, boolean orderRgb) {
        if (src instanceof ImageGray) {
            if (GrayU8.class == src.getClass()) {
                return ConvertBufferedImage.convertTo((GrayU8)src, dst);
            }
            if (GrayI16.class.isInstance(src)) {
                return ConvertBufferedImage.convertTo((GrayI16)src, dst);
            }
            if (GrayF32.class == src.getClass()) {
                return ConvertBufferedImage.convertTo((GrayF32)src, dst);
            }
            throw new IllegalArgumentException("ImageGray type is not yet supported: " + src.getClass().getSimpleName());
        }
        if (src instanceof Planar) {
            Planar ms = (Planar)src;
            if (GrayU8.class == ms.getBandType()) {
                return ConvertBufferedImage.convertTo_U8(ms, dst, orderRgb);
            }
            if (GrayF32.class == ms.getBandType()) {
                return ConvertBufferedImage.convertTo_F32(ms, dst, orderRgb);
            }
            throw new IllegalArgumentException("Planar type is not yet supported: " + ms.getBandType().getSimpleName());
        }
        if (src instanceof ImageInterleaved) {
            if (InterleavedU8.class == src.getClass()) {
                return ConvertBufferedImage.convertTo((InterleavedU8)src, dst, orderRgb);
            }
            if (InterleavedF32.class == src.getClass()) {
                return ConvertBufferedImage.convertTo((InterleavedF32)src, dst, orderRgb);
            }
            throw new IllegalArgumentException("ImageGray type is not yet supported: " + src.getClass().getSimpleName());
        }
        throw new IllegalArgumentException("Image type is not yet supported: " + src.getClass().getSimpleName());
    }

    public static BufferedImage convertTo(GrayU8 src, BufferedImage dst) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.grayToBuffered(src, (ByteInterleavedRaster)dst.getRaster());
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.grayToBuffered(src, (IntegerInterleavedRaster)dst.getRaster());
            } else {
                ConvertRaster.grayToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.grayToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo(GrayI16 src, BufferedImage dst) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.grayToBuffered(src, (ByteInterleavedRaster)dst.getRaster());
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.grayToBuffered(src, (IntegerInterleavedRaster)dst.getRaster());
            } else if (dst.getType() == 11) {
                ConvertRaster.grayToBuffered(src, (ShortInterleavedRaster)dst.getRaster());
            } else {
                ConvertRaster.grayToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.grayToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo(GrayF32 src, BufferedImage dst) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.grayToBuffered(src, (ByteInterleavedRaster)dst.getRaster());
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.grayToBuffered(src, (IntegerInterleavedRaster)dst.getRaster());
            } else {
                ConvertRaster.grayToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.grayToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo_U8(Planar<GrayU8> src, BufferedImage dst, boolean orderRgb) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        if (orderRgb) {
            src = ConvertBufferedImage.orderBandsIntoBuffered(src, dst);
        }
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.multToBuffered_U8((Planar<GrayU8>)src, (ByteInterleavedRaster)dst.getRaster());
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.multToBuffered_U8((Planar<GrayU8>)src, (IntegerInterleavedRaster)dst.getRaster());
            } else {
                ConvertRaster.multToBuffered_U8((Planar<GrayU8>)src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.multToBuffered_U8((Planar<GrayU8>)src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo_F32(Planar<GrayF32> src, BufferedImage dst, boolean orderRgb) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        if (orderRgb) {
            src = ConvertBufferedImage.orderBandsIntoBuffered(src, dst);
        }
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.multToBuffered_F32((Planar<GrayF32>)src, (ByteInterleavedRaster)dst.getRaster());
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.multToBuffered_F32((Planar<GrayF32>)src, (IntegerInterleavedRaster)dst.getRaster());
            } else {
                ConvertRaster.multToBuffered_F32((Planar<GrayF32>)src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.multToBuffered_F32((Planar<GrayF32>)src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo(InterleavedU8 src, BufferedImage dst, boolean orderRgb) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.interleavedToBuffered(src, (ByteInterleavedRaster)dst.getRaster());
                if (orderRgb) {
                    ConvertBufferedImage.orderBandsBufferedFromRGB((ByteInterleavedRaster)dst.getRaster(), dst.getType());
                }
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.interleavedToBuffered(src, (IntegerInterleavedRaster)dst.getRaster());
                if (orderRgb) {
                    ConvertBufferedImage.orderBandsBufferedFromRGB((IntegerInterleavedRaster)dst.getRaster(), dst.getType());
                }
            } else {
                ConvertRaster.interleavedToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.interleavedToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage convertTo(InterleavedF32 src, BufferedImage dst, boolean orderRgb) {
        dst = ConvertBufferedImage.checkInputs(src, dst);
        try {
            if (dst.getRaster() instanceof ByteInterleavedRaster && dst.getType() != 13) {
                ConvertRaster.interleavedToBuffered(src, (ByteInterleavedRaster)dst.getRaster());
                if (orderRgb) {
                    ConvertBufferedImage.orderBandsBufferedFromRGB((ByteInterleavedRaster)dst.getRaster(), dst.getType());
                }
            } else if (dst.getRaster() instanceof IntegerInterleavedRaster) {
                ConvertRaster.interleavedToBuffered(src, (IntegerInterleavedRaster)dst.getRaster());
                if (orderRgb) {
                    ConvertBufferedImage.orderBandsBufferedFromRGB((IntegerInterleavedRaster)dst.getRaster(), dst.getType());
                }
            } else {
                ConvertRaster.interleavedToBuffered(src, dst);
            }
            dst.setRGB(0, 0, dst.getRGB(0, 0));
        }
        catch (AccessControlException e) {
            ConvertRaster.interleavedToBuffered(src, dst);
        }
        return dst;
    }

    public static BufferedImage checkInputs(ImageBase src, BufferedImage dst) {
        if (dst != null) {
            if (dst.getWidth() != src.getWidth() || dst.getHeight() != src.getHeight()) {
                throw new IllegalArgumentException("image dimension are different");
            }
        } else {
            dst = GrayI8.class.isInstance(src) ? new BufferedImage(src.getWidth(), src.getHeight(), 10) : (GrayF.class.isInstance(src) ? new BufferedImage(src.getWidth(), src.getHeight(), 10) : (GrayI.class.isInstance(src) ? new BufferedImage(src.getWidth(), src.getHeight(), 11) : new BufferedImage(src.getWidth(), src.getHeight(), 1)));
        }
        return dst;
    }

    public static BufferedImage convertTo(JComponent comp, BufferedImage storage) {
        if (storage == null) {
            storage = new BufferedImage(comp.getWidth(), comp.getHeight(), 1);
        }
        Graphics2D g2 = storage.createGraphics();
        comp.paintComponents(g2);
        return storage;
    }

    public static Planar orderBandsIntoBuffered(Planar src, BufferedImage dst) {
        if (dst.getType() == 1) {
            return src;
        }
        Planar tmp = new Planar(src.type, src.getNumBands());
        tmp.width = src.width;
        tmp.height = src.height;
        tmp.stride = src.stride;
        tmp.startIndex = src.startIndex;
        for (int i = 0; i < src.getNumBands(); ++i) {
            tmp.bands[i] = src.bands[i];
        }
        ConvertBufferedImage.orderBandsBufferedFromRgb(tmp, dst);
        return tmp;
    }

    public static void orderBandsBufferedFromRGB(ByteInterleavedRaster raster, int type) {
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = raster.getScanlineStride();
        int offset = raster.getDataOffset(0) - raster.getPixelStride() + 1;
        byte[] data = raster.getDataStorage();
        if (5 == type) {
            for (int y = 0; y < height; ++y) {
                int index = offset + y * stride;
                for (int x = 0; x < width; ++x) {
                    byte tmp = data[index];
                    data[index] = data[index + 2];
                    data[index + 2] = tmp;
                    index += 3;
                }
            }
        } else if (6 == type) {
            for (int y = 0; y < height; ++y) {
                int index = offset + y * stride;
                for (int x = 0; x < width; ++x) {
                    byte tmp0 = data[index];
                    byte tmp1 = data[index + 1];
                    data[index] = data[index + 3];
                    data[index + 1] = data[index + 2];
                    data[index + 2] = tmp1;
                    data[index + 3] = tmp0;
                    index += 4;
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported buffered image type");
        }
    }

    public static void orderBandsBufferedFromRGB(IntegerInterleavedRaster raster, int type) {
        if (1 == type) {
            return;
        }
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = raster.getScanlineStride();
        int offset = raster.getDataOffset(0) - raster.getPixelStride() + 1;
        int[] data = raster.getDataStorage();
        if (4 == type) {
            for (int y = 0; y < height; ++y) {
                int index = offset + y * stride;
                int x = 0;
                while (x < width) {
                    int tmp = data[index];
                    int c1 = tmp & 0xFF;
                    int c2 = tmp >> 8 & 0xFF;
                    int c3 = tmp >> 16 & 0xFF;
                    data[index] = c1 << 16 | c2 << 8 | c3;
                    ++x;
                    ++index;
                }
            }
        } else if (2 == type) {
            for (int y = 0; y < height; ++y) {
                int index = offset + y * stride;
                int x = 0;
                while (x < width) {
                    int tmp = data[index];
                    int c1 = tmp & 0xFF;
                    int c2 = tmp >> 8 & 0xFF;
                    int c3 = tmp >> 16 & 0xFF;
                    int c4 = tmp >> 24 & 0xFF;
                    data[index] = c1 << 24 | c4 << 16 | c3 << 8 | c2;
                    ++x;
                    ++index;
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported buffered image type");
        }
    }

    public static <T extends ImageGray> void orderBandsIntoRGB(Planar<T> image, BufferedImage input) {
        boolean swap = ConvertBufferedImage.swapBandOrder(input);
        if (swap) {
            if (image.getNumBands() == 3) {
                int bufferedImageType = input.getType();
                if (bufferedImageType == 5 || bufferedImageType == 4) {
                    T tmp = image.getBand(0);
                    image.bands[0] = image.getBand(2);
                    image.bands[2] = tmp;
                }
            } else if (image.getNumBands() == 4) {
                ImageGray[] temp = (ImageGray[])Array.newInstance(image.getBandType(), 4);
                int bufferedImageType = input.getType();
                if (bufferedImageType == 2) {
                    temp[0] = image.getBand(1);
                    temp[1] = image.getBand(2);
                    temp[2] = image.getBand(3);
                    temp[3] = image.getBand(0);
                } else if (bufferedImageType == 6) {
                    temp[0] = image.getBand(3);
                    temp[1] = image.getBand(2);
                    temp[2] = image.getBand(1);
                    temp[3] = image.getBand(0);
                }
                image.bands[0] = temp[0];
                image.bands[1] = temp[1];
                image.bands[2] = temp[2];
                image.bands[3] = temp[3];
            }
        }
    }

    public static <T extends ImageGray> void orderBandsBufferedFromRgb(Planar<T> image, BufferedImage input) {
        boolean swap = ConvertBufferedImage.swapBandOrder(input);
        if (swap) {
            if (image.getNumBands() == 3) {
                int bufferedImageType = input.getType();
                if (bufferedImageType == 5 || bufferedImageType == 4) {
                    T tmp = image.getBand(0);
                    image.bands[0] = image.getBand(2);
                    image.bands[2] = tmp;
                }
            } else if (image.getNumBands() == 4) {
                ImageGray[] temp = (ImageGray[])Array.newInstance(image.getBandType(), 4);
                int bufferedImageType = input.getType();
                if (bufferedImageType == 2) {
                    temp[0] = image.getBand(3);
                    temp[1] = image.getBand(0);
                    temp[2] = image.getBand(1);
                    temp[3] = image.getBand(2);
                } else if (bufferedImageType == 6) {
                    temp[0] = image.getBand(3);
                    temp[1] = image.getBand(2);
                    temp[2] = image.getBand(1);
                    temp[3] = image.getBand(0);
                }
                image.bands[0] = temp[0];
                image.bands[1] = temp[1];
                image.bands[2] = temp[2];
                image.bands[3] = temp[3];
            }
        }
    }

    public static void orderBandsIntoRGB(ImageInterleaved image, BufferedImage input) {
        if (image instanceof InterleavedU8) {
            ConvertBufferedImage.orderBandsIntoRGB((InterleavedU8)image, input);
        } else if (image instanceof InterleavedF32) {
            ConvertBufferedImage.orderBandsIntoRGB((InterleavedF32)image, input);
        } else {
            throw new IllegalArgumentException("Unsupported interleaved type");
        }
    }

    public static void orderBandsIntoRGB(InterleavedU8 image, BufferedImage input) {
        block6: {
            int bufferedImageType;
            block8: {
                block7: {
                    boolean swap = ConvertBufferedImage.swapBandOrder(input);
                    if (!swap) break block6;
                    if (image.getNumBands() != 3) break block7;
                    for (int y = 0; y < image.height; ++y) {
                        int index;
                        int indexEnd = index + image.width * 3;
                        for (index = image.startIndex + y * image.stride; index < indexEnd; index += 3) {
                            byte tmp = image.data[index + 2];
                            image.data[index + 2] = image.data[index];
                            image.data[index] = tmp;
                        }
                    }
                    break block6;
                }
                if (image.getNumBands() != 4) break block6;
                bufferedImageType = input.getType();
                if (bufferedImageType != 2) break block8;
                for (int y = 0; y < image.height; ++y) {
                    int index;
                    int indexEnd = index + image.width * 3;
                    for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                        byte tmp = image.data[index];
                        image.data[index] = image.data[index + 1];
                        image.data[index + 1] = image.data[index + 2];
                        image.data[index + 2] = image.data[index + 3];
                        image.data[index + 3] = tmp;
                    }
                }
                break block6;
            }
            if (bufferedImageType != 6) break block6;
            for (int y = 0; y < image.height; ++y) {
                int index;
                int indexEnd = index + image.width * 3;
                for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                    byte tmp1 = image.data[index + 1];
                    byte tmp0 = image.data[index];
                    image.data[index] = image.data[index + 3];
                    image.data[index + 1] = image.data[index + 2];
                    image.data[index + 2] = tmp1;
                    image.data[index + 3] = tmp0;
                }
            }
        }
    }

    public static void orderBandsIntoRGB(InterleavedF32 image, BufferedImage input) {
        block6: {
            int bufferedImageType;
            block8: {
                block7: {
                    boolean swap = ConvertBufferedImage.swapBandOrder(input);
                    if (!swap) break block6;
                    if (image.getNumBands() != 3) break block7;
                    for (int y = 0; y < image.height; ++y) {
                        int index;
                        int indexEnd = index + image.width * 3;
                        for (index = image.startIndex + y * image.stride; index < indexEnd; index += 3) {
                            float tmp = image.data[index + 2];
                            image.data[index + 2] = image.data[index];
                            image.data[index] = tmp;
                        }
                    }
                    break block6;
                }
                if (image.getNumBands() != 4) break block6;
                bufferedImageType = input.getType();
                if (bufferedImageType != 2) break block8;
                for (int y = 0; y < image.height; ++y) {
                    int index;
                    int indexEnd = index + image.width * 3;
                    for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                        float tmp = image.data[index];
                        image.data[index] = image.data[index + 1];
                        image.data[index + 1] = image.data[index + 2];
                        image.data[index + 2] = image.data[index + 3];
                        image.data[index + 3] = tmp;
                    }
                }
                break block6;
            }
            if (bufferedImageType != 6) break block6;
            for (int y = 0; y < image.height; ++y) {
                int index;
                int indexEnd = index + image.width * 3;
                for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                    float tmp1 = image.data[index + 1];
                    float tmp0 = image.data[index];
                    image.data[index] = image.data[index + 3];
                    image.data[index + 1] = image.data[index + 2];
                    image.data[index + 2] = tmp1;
                    image.data[index + 3] = tmp0;
                }
            }
        }
    }

    private static boolean swapBandOrder(BufferedImage input) {
        boolean swap = false;
        try {
            WritableRaster raster = input.getRaster();
            if (raster instanceof ByteInterleavedRaster) {
                ((ByteInterleavedRaster)raster).getDataStorage();
            } else if (raster instanceof IntegerInterleavedRaster) {
                ((IntegerInterleavedRaster)raster).getDataStorage();
            }
            int bufferedImageType = input.getType();
            if (bufferedImageType == 5 || bufferedImageType == 4 || bufferedImageType == 2 || bufferedImageType == 6) {
                swap = true;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return swap;
    }

    public static boolean isSubImage(BufferedImage img) {
        return img.getRaster().getParent() != null;
    }
}

