/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.dense;

import boofcv.alg.feature.dense.DescribeDenseHogAlg;
import boofcv.alg.feature.dense.impl.DescribeDenseHogAlg_F32;
import boofcv.alg.feature.dense.impl.DescribeDenseHogAlg_PLF32;
import boofcv.alg.feature.dense.impl.DescribeDenseHogAlg_PLU8;
import boofcv.alg.feature.dense.impl.DescribeDenseHogAlg_U8;
import boofcv.factory.feature.dense.ConfigDenseHoG;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public class FactoryDescribeImageDenseAlg {
    public static <T extends ImageBase, D extends ImageBase> DescribeDenseHogAlg<T, D> hog(ConfigDenseHoG config, ImageType<T> imageType) {
        DescribeDenseHogAlg hog;
        block9: {
            block10: {
                block8: {
                    config.checkValidity();
                    if (imageType.getFamily() != ImageType.Family.GRAY) break block8;
                    switch (imageType.getDataType()) {
                        case U8: {
                            hog = new DescribeDenseHogAlg_U8(config.orientationBins, config.widthCell, config.widthBlock, config.stepBlock);
                            break block9;
                        }
                        case F32: {
                            hog = new DescribeDenseHogAlg_F32(config.orientationBins, config.widthCell, config.widthBlock, config.stepBlock);
                            break block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported image type");
                        }
                    }
                }
                if (imageType.getFamily() != ImageType.Family.PLANAR) break block10;
                switch (imageType.getDataType()) {
                    case U8: {
                        hog = new DescribeDenseHogAlg_PLU8(config.orientationBins, config.widthCell, config.widthBlock, config.stepBlock, imageType.getNumBands());
                        break block9;
                    }
                    case F32: {
                        hog = new DescribeDenseHogAlg_PLF32(config.orientationBins, config.widthCell, config.widthBlock, config.stepBlock, imageType.getNumBands());
                        break block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported image type");
                    }
                }
            }
            throw new IllegalArgumentException("Unsupported image type");
        }
        return hog;
    }
}

