/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.tracking;

import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.factory.tracker.FactoryTrackerObjectQuad;
import boofcv.gui.image.ShowImages;
import boofcv.gui.tracker.TrackerObjectQuadPanel;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayU8;
import georegression.struct.shapes.Quadrilateral_F64;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class ExampleTrackerObjectQuad {
    public static void main(String[] args) {
        DefaultMediaManager media = DefaultMediaManager.INSTANCE;
        String fileName = UtilIO.pathExample("tracking/wildcat_robot.mjpeg");
        TrackerObjectQuad<GrayU8> tracker = FactoryTrackerObjectQuad.circulant(null, GrayU8.class);
        SimpleImageSequence<GrayU8> video = media.openVideo(fileName, tracker.getImageType());
        Quadrilateral_F64 location = new Quadrilateral_F64(211.0, 162.0, 326.0, 153.0, 335.0, 258.0, 215.0, 249.0);
        GrayU8 frame = video.next();
        tracker.initialize(frame, location);
        TrackerObjectQuadPanel gui = new TrackerObjectQuadPanel(null);
        gui.setPreferredSize(new Dimension(frame.getWidth(), frame.getHeight()));
        gui.setBackGround((BufferedImage)video.getGuiImage());
        gui.setTarget(location, true);
        ShowImages.showWindow(gui, "Tracking Results", true);
        long previous = 0L;
        while (video.hasNext()) {
            frame = video.next();
            boolean visible = tracker.process(frame, location);
            gui.setBackGround((BufferedImage)video.getGuiImage());
            gui.setTarget(location, visible);
            gui.repaint();
            long time = System.currentTimeMillis();
            BoofMiscOps.pause(Math.max(0L, 80L - (time - previous)));
            previous = time;
        }
    }
}

