/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.stereo;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.core.image.border.BorderType;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.stereo.RectifiedPairPanel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.Planar;
import georegression.struct.se.Se3_F64;
import java.awt.image.BufferedImage;
import org.ejml.data.DenseMatrix64F;

public class ExampleRectifyCalibratedStereo {
    public static void main(String[] args) {
        String dir = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess/");
        StereoParameters param = (StereoParameters)UtilIO.loadXML(dir, "stereo.xml");
        BufferedImage origLeft = UtilImageIO.loadImage(dir, "left05.jpg");
        BufferedImage origRight = UtilImageIO.loadImage(dir, "right05.jpg");
        Planar<GrayF32> distLeft = ConvertBufferedImage.convertFromMulti(origLeft, null, true, GrayF32.class);
        Planar<GrayF32> distRight = ConvertBufferedImage.convertFromMulti(origRight, null, true, GrayF32.class);
        Planar rectLeft = (Planar)distLeft.createSameShape();
        Planar rectRight = (Planar)distRight.createSameShape();
        RectifyCalibrated rectifyAlg = RectifyImageOps.createCalibrated();
        Se3_F64 leftToRight = param.getRightToLeft().invert(null);
        DenseMatrix64F K1 = PerspectiveOps.calibrationMatrix(param.getLeft(), null);
        DenseMatrix64F K2 = PerspectiveOps.calibrationMatrix(param.getRight(), null);
        rectifyAlg.process(K1, new Se3_F64(), K2, leftToRight);
        DenseMatrix64F rect1 = rectifyAlg.getRect1();
        DenseMatrix64F rect2 = rectifyAlg.getRect2();
        DenseMatrix64F rectK = rectifyAlg.getCalibrationMatrix();
        RectifyImageOps.fullViewLeft(param.left, rect1, rect2, rectK);
        ImageDistort rectifyImageLeft = RectifyImageOps.rectifyImage(param.getLeft(), rect1, BorderType.SKIP, distLeft.getImageType());
        ImageDistort rectifyImageRight = RectifyImageOps.rectifyImage(param.getRight(), rect2, BorderType.SKIP, distRight.getImageType());
        rectifyImageLeft.apply(distLeft, rectLeft);
        rectifyImageRight.apply(distRight, rectRight);
        BufferedImage outLeft = ConvertBufferedImage.convertTo(rectLeft, null, true);
        BufferedImage outRight = ConvertBufferedImage.convertTo(rectRight, null, true);
        ListDisplayPanel panel = new ListDisplayPanel();
        panel.addItem(new RectifiedPairPanel(true, origLeft, origRight), "Original");
        panel.addItem(new RectifiedPairPanel(true, outLeft, outRight), "Rectified");
        ShowImages.showWindow(panel, "Stereo Rectification Calibrated", true);
    }
}

