/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.sfm;

import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.disparity.StereoDisparitySparse;
import boofcv.abst.feature.tracker.PointTrackerTwoPass;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.factory.feature.disparity.FactoryStereoDisparity;
import boofcv.factory.feature.tracker.FactoryPointTrackerTwoPass;
import boofcv.factory.sfm.FactoryVisualOdometry;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;

public class ExampleVisualOdometryStereo {
    public static void main(String[] args) {
        DefaultMediaManager media = DefaultMediaManager.INSTANCE;
        String directory = UtilIO.pathExample("vo/backyard/");
        StereoParameters stereoParam = (StereoParameters)UtilIO.loadXML(media.openFile(directory + "stereo.xml"));
        SimpleImageSequence<GrayU8> video1 = media.openVideo(directory + "left.mjpeg", ImageType.single(GrayU8.class));
        SimpleImageSequence<GrayU8> video2 = media.openVideo(directory + "right.mjpeg", ImageType.single(GrayU8.class));
        PkltConfig configKlt = new PkltConfig();
        configKlt.pyramidScaling = new int[]{1, 2, 4, 8};
        configKlt.templateRadius = 3;
        PointTrackerTwoPass<GrayU8> tracker = FactoryPointTrackerTwoPass.klt(configKlt, new ConfigGeneralDetector(600, 3, 1.0f), GrayU8.class, GrayS16.class);
        StereoDisparitySparse<GrayU8> disparity = FactoryStereoDisparity.regionSparseWta(0, 150, 3, 3, 30.0, -1.0, true, GrayU8.class);
        StereoVisualOdometry<GrayU8> visualOdometry = FactoryVisualOdometry.stereoDepth(1.5, 120, 2, 200, 50, true, disparity, tracker, GrayU8.class);
        visualOdometry.setCalibration(stereoParam);
        while (video1.hasNext()) {
            GrayU8 right;
            GrayU8 left = video1.next();
            if (!visualOdometry.process(left, right = video2.next())) {
                throw new RuntimeException("VO Failed!");
            }
            Se3_F64 leftToWorld = (Se3_F64)visualOdometry.getCameraToWorld();
            Vector3D_F64 T = leftToWorld.getT();
            System.out.printf("Location %8.2f %8.2f %8.2f      inliers %s\n", T.x, T.y, T.z, ExampleVisualOdometryStereo.inlierPercent(visualOdometry));
        }
    }

    public static String inlierPercent(StereoVisualOdometry alg) {
        if (!(alg instanceof AccessPointTracks3D)) {
            return "";
        }
        AccessPointTracks3D access = (AccessPointTracks3D)((Object)alg);
        int count = 0;
        int N = access.getAllTracks().size();
        for (int i = 0; i < N; ++i) {
            if (!access.isInlier(i)) continue;
            ++count;
        }
        return String.format("%%%5.3f", 100.0 * (double)count / (double)N);
    }
}

