/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.imageprocessing;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.gui.image.DiscretePyramidPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidDiscrete;
import java.awt.image.BufferedImage;

public class ExamplePyramidDiscrete<T extends ImageGray> {
    Class<T> imageType;
    PyramidDiscrete<T> pyramid;

    public ExamplePyramidDiscrete(Class<T> imageType) {
        this.imageType = imageType;
    }

    public void standard() {
        this.pyramid = FactoryPyramid.discreteGaussian(new int[]{1, 2, 4, 8}, -1.0, 2, true, this.imageType);
    }

    public void unusual() {
        this.pyramid = FactoryPyramid.discreteGaussian(new int[]{2, 6}, -1.0, 2, true, this.imageType);
        if (GeneralizedImageOps.isFloatingPoint(this.imageType)) {
            Kernel1D_F32 kernel = FactoryKernel.table1D_F32(2, true);
        } else {
            Kernel1D_I32 kernel = FactoryKernel.table1D_I32(2);
        }
    }

    public void process(BufferedImage image) {
        Object input = ConvertBufferedImage.convertFromSingle(image, null, this.imageType);
        this.pyramid.process(input);
        DiscretePyramidPanel<T> gui = new DiscretePyramidPanel<T>();
        gui.setPyramid(this.pyramid);
        gui.render();
        ShowImages.showWindow(gui, "Image Pyramid");
        ImageBase imageAtScale = this.pyramid.getLayer(1);
        ShowImages.showWindow(ConvertBufferedImage.convertTo(imageAtScale, null, true), "Image at layer 1");
    }

    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("standard/barbara.jpg"));
        ExamplePyramidDiscrete<GrayF32> app = new ExamplePyramidDiscrete<GrayF32>(GrayF32.class);
        app.standard();
        app.process(image);
    }
}

