/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.features;

import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.feature.VisualizeShapes;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayU8;
import georegression.struct.shapes.Polygon2D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import org.ddogleg.struct.FastQueue;

public class ExampleDetectBlackPolygon {
    public static void main(String[] args) {
        String[] imagesConvex = new String[]{"shapes/polygons01.jpg", "shapes/shapes02.png", "fiducial/image/examples/image01.jpg"};
        String[] imagesConcave = new String[]{"shapes/concave01.jpg"};
        ListDisplayPanel panel = new ListDisplayPanel();
        ConfigPolygonDetector config = new ConfigPolygonDetector(3, 7);
        BinaryPolygonDetector<GrayU8> detector = FactoryShapeDetector.polygon(config, GrayU8.class);
        ExampleDetectBlackPolygon.processImages(imagesConvex, detector, panel);
        config.maximumSides = 12;
        config.convex = false;
        detector = FactoryShapeDetector.polygon(config, GrayU8.class);
        ExampleDetectBlackPolygon.processImages(imagesConcave, detector, panel);
        ShowImages.showWindow(panel, "Found Polygons", true);
    }

    private static void processImages(String[] files, BinaryPolygonDetector<GrayU8> detector, ListDisplayPanel panel) {
        for (String fileName : files) {
            BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample(fileName));
            GrayU8 input = ConvertBufferedImage.convertFromSingle(image, null, GrayU8.class);
            GrayU8 binary = new GrayU8(input.width, input.height);
            int threshold = GThresholdImageOps.computeOtsu(input, 0, 255);
            ThresholdImageOps.threshold(input, binary, threshold, true);
            detector.process(input, binary);
            FastQueue<Polygon2D_F64> found = detector.getFoundPolygons();
            Graphics2D g2 = image.createGraphics();
            g2.setStroke(new BasicStroke(3.0f));
            for (int i = 0; i < found.size; ++i) {
                g2.setColor(Color.RED);
                VisualizeShapes.drawPolygon((Polygon2D_F64)found.get(i), true, g2, true);
                g2.setColor(Color.CYAN);
                VisualizeShapes.drawPolygonCorners((Polygon2D_F64)found.get(i), 2, g2, true);
            }
            panel.addImage(image, new File(fileName).getName());
        }
    }
}

