/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.enhance;

import boofcv.abst.denoise.FactoryImageDenoise;
import boofcv.abst.denoise.WaveletDenoiseFilter;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import java.util.Random;

public class ExampleWaveletDenoise {
    public static void main(String[] args) {
        Random rand = new Random(234L);
        GrayF32 input = UtilImageIO.loadImage(UtilIO.pathExample("standard/lena512.jpg"), GrayF32.class);
        GrayF32 noisy = (GrayF32)input.clone();
        GImageMiscOps.addGaussian(noisy, rand, 20.0, 0.0, 255.0);
        GrayF32 denoised = (GrayF32)noisy.createSameShape();
        int numLevels = 4;
        WaveletDenoiseFilter<GrayF32> denoiser = FactoryImageDenoise.waveletBayes(GrayF32.class, numLevels, 0.0, 255.0);
        denoiser.process(noisy, denoised);
        ListDisplayPanel gui = new ListDisplayPanel();
        gui.addImage(ConvertBufferedImage.convertTo(input, null), "Input");
        gui.addImage(ConvertBufferedImage.convertTo(noisy, null), "Noisy");
        gui.addImage(ConvertBufferedImage.convertTo(denoised, null), "Denoised");
        ShowImages.showWindow(gui, "Wavelet Noise Removal Example", true);
    }
}

