/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.enhance;

import boofcv.alg.enhance.EnhanceImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayU8;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class ExampleImageEnhancement {
    static String imagePath = "enhance/dark.jpg";
    static ListDisplayPanel mainPanel = new ListDisplayPanel();

    public static void histogram() {
        BufferedImage buffered = UtilImageIO.loadImage(UtilIO.pathExample(imagePath));
        GrayU8 gray = ConvertBufferedImage.convertFrom(buffered, (GrayU8)null);
        GrayU8 adjusted = (GrayU8)gray.createSameShape();
        int[] histogram = new int[256];
        int[] transform = new int[256];
        ListDisplayPanel panel = new ListDisplayPanel();
        ImageStatistics.histogram(gray, histogram);
        EnhanceImageOps.equalize(histogram, transform);
        EnhanceImageOps.applyTransform(gray, transform, adjusted);
        panel.addImage(ConvertBufferedImage.convertTo(adjusted, null), "Global");
        EnhanceImageOps.equalizeLocal(gray, 50, adjusted, histogram, transform);
        panel.addImage(ConvertBufferedImage.convertTo(adjusted, null), "Local");
        panel.addImage(ConvertBufferedImage.convertTo(gray, null), "Original");
        panel.setPreferredSize(new Dimension(gray.width, gray.height));
        mainPanel.addItem(panel, "Histogram");
    }

    public static void sharpen() {
        BufferedImage buffered = UtilImageIO.loadImage(UtilIO.pathExample(imagePath));
        GrayU8 gray = ConvertBufferedImage.convertFrom(buffered, (GrayU8)null);
        GrayU8 adjusted = (GrayU8)gray.createSameShape();
        ListDisplayPanel panel = new ListDisplayPanel();
        EnhanceImageOps.sharpen4(gray, adjusted);
        panel.addImage(ConvertBufferedImage.convertTo(adjusted, null), "Sharpen-4");
        EnhanceImageOps.sharpen8(gray, adjusted);
        panel.addImage(ConvertBufferedImage.convertTo(adjusted, null), "Sharpen-8");
        panel.addImage(ConvertBufferedImage.convertTo(gray, null), "Original");
        panel.setPreferredSize(new Dimension(gray.width, gray.height));
        mainPanel.addItem(panel, "Sharpen");
    }

    public static void main(String[] args) {
        ExampleImageEnhancement.histogram();
        ExampleImageEnhancement.sharpen();
        ShowImages.showWindow(mainPanel, "Enhancement", true);
    }
}

