/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.calibration;

import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.geo.calibration.CalibrateStereoPlanar;
import boofcv.abst.geo.calibration.CalibrationDetector;
import boofcv.factory.calib.FactoryCalibrationTarget;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.GrayF32;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;

public class ExampleCalibrateStereo {
    CalibrationDetector detector;
    List<String> left;
    List<String> right;

    public void setupBumblebeeSquare() {
        this.detector = FactoryCalibrationTarget.detectorSquareGrid(new ConfigSquareGrid(4, 3, 30.0, 30.0));
        String directory = UtilIO.pathExample("calibration/stereo/Bumblebee2_Square");
        this.left = BoofMiscOps.directoryList(directory, "left");
        this.right = BoofMiscOps.directoryList(directory, "right");
    }

    public void setupBumblebeeChess() {
        this.detector = FactoryCalibrationTarget.detectorChessboard(new ConfigChessboard(7, 5, 30.0));
        String directory = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess");
        this.left = BoofMiscOps.directoryList(directory, "left");
        this.right = BoofMiscOps.directoryList(directory, "right");
    }

    public void process() {
        CalibrateStereoPlanar calibratorAlg = new CalibrateStereoPlanar(this.detector);
        calibratorAlg.configure(true, 2, false);
        Collections.sort(this.left);
        Collections.sort(this.right);
        for (int i = 0; i < this.left.size(); ++i) {
            GrayF32 imageRight;
            BufferedImage l = UtilImageIO.loadImage(this.left.get(i));
            BufferedImage r = UtilImageIO.loadImage(this.right.get(i));
            GrayF32 imageLeft = ConvertBufferedImage.convertFrom(l, (GrayF32)null);
            if (calibratorAlg.addPair(imageLeft, imageRight = ConvertBufferedImage.convertFrom(r, (GrayF32)null))) continue;
            System.out.println("Failed to detect target in " + this.left.get(i) + " and/or " + this.right.get(i));
        }
        StereoParameters stereoCalib = calibratorAlg.process();
        calibratorAlg.printStatistics();
        UtilIO.saveXML(stereoCalib, "stereo.xml");
        stereoCalib.print();
    }

    public static void main(String[] args) {
        ExampleCalibrateStereo alg = new ExampleCalibrateStereo();
        alg.setupBumblebeeChess();
        alg.process();
    }
}

