/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.transform.pyramid;

import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.gui.SelectInputPanel;
import boofcv.gui.VisualizeApp;
import boofcv.gui.image.DiscretePyramidPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidDiscrete;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class VisualizePyramidDiscreteApp<T extends ImageGray>
extends SelectInputPanel
implements VisualizeApp {
    int[] scales = new int[]{1, 2, 4, 8, 16};
    Class<T> imageType;
    DiscretePyramidPanel gui = new DiscretePyramidPanel();
    PyramidDiscrete<T> pyramid;
    boolean processedImage = false;

    public VisualizePyramidDiscreteApp(Class<T> imageType) {
        this.imageType = imageType;
        this.pyramid = FactoryPyramid.discreteGaussian(this.scales, -1.0, 2, true, imageType);
        this.gui = new DiscretePyramidPanel();
        this.setMainGUI(this.gui);
    }

    public void process(BufferedImage input) {
        this.setInputImage(input);
        Object gray = ConvertBufferedImage.convertFromSingle(input, null, this.imageType);
        this.pyramid.process(gray);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizePyramidDiscreteApp.this.gui.setPyramid(VisualizePyramidDiscreteApp.this.pyramid);
                VisualizePyramidDiscreteApp.this.gui.render();
                VisualizePyramidDiscreteApp.this.gui.repaint();
                VisualizePyramidDiscreteApp.this.processedImage = true;
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public synchronized void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    public static void main(String[] args) {
        VisualizePyramidDiscreteApp<GrayF32> app = new VisualizePyramidDiscreteApp<GrayF32>(GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("lena", UtilIO.pathExample("standard/lena512.jpg")));
        inputs.add(new PathLabel("boat", UtilIO.pathExample("standard/boat.jpg")));
        inputs.add(new PathLabel("fingerprint", UtilIO.pathExample("standard/fingerprint.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Image Discrete Pyramid", true);
    }
}

