/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.tracker;

import boofcv.abst.tracker.ConfigCirculantTracker;
import boofcv.alg.tracker.circulant.CirculantTracker;
import boofcv.demonstrations.tracker.CirculantVisualizationPanel;
import boofcv.factory.tracker.FactoryTrackerObjectAlgs;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.shapes.RectangleLength2D_F32;
import java.awt.image.BufferedImage;

public class VisualizeCirculantTrackerApp<T extends ImageGray>
implements CirculantVisualizationPanel.Listener {
    CirculantTracker<T> tracker;
    CirculantVisualizationPanel gui;
    T image;
    boolean paused;

    public VisualizeCirculantTrackerApp(Class<T> imageType) {
        ConfigCirculantTracker config = new ConfigCirculantTracker();
        this.tracker = FactoryTrackerObjectAlgs.circulant(config, imageType);
        this.gui = new CirculantVisualizationPanel(this);
    }

    public void process(SimpleImageSequence<T> sequence) {
        if (!sequence.hasNext()) {
            throw new IllegalArgumentException("Empty sequence");
        }
        this.image = (ImageGray)sequence.next();
        this.gui.setFrame((BufferedImage)sequence.getGuiImage());
        ShowImages.showWindow(this.gui, "Circulant Tracker");
        this.paused = true;
        while (this.paused) {
            Thread.yield();
        }
        int totalFrames = 0;
        long totalTime = 0L;
        while (sequence.hasNext()) {
            ++totalFrames;
            this.image = (ImageGray)sequence.next();
            this.gui.setFrame((BufferedImage)sequence.getGuiImage());
            long before = System.nanoTime();
            this.tracker.performTracking(this.image);
            long after = System.nanoTime();
            System.out.println("FPS = " + (double)totalFrames / ((double)(totalTime += after - before) / 2.0E9));
            this.gui.update(this.tracker);
            RectangleLength2D_F32 r = this.tracker.getTargetLocation();
            System.out.println("Target: " + r);
            this.gui.repaint();
            while (this.paused) {
                Thread.yield();
            }
        }
        System.out.println("DONE");
    }

    @Override
    public void startTracking(int x0, int y0, int x1, int y1) {
        System.out.println(x0 + "," + y0 + "," + x1 + "," + y1);
        this.tracker.initialize(this.image, x0, y0, x1 - x0, y1 - y0);
        this.paused = false;
    }

    @Override
    public void togglePause() {
        this.paused = !this.paused;
    }

    public static void main(String[] args) {
        VisualizeCirculantTrackerApp<GrayU8> app = new VisualizeCirculantTrackerApp<GrayU8>(GrayU8.class);
        String fileName = UtilIO.pathExample("tracking/snow_follow_car.mjpeg");
        SimpleImageSequence<GrayU8> sequence = DefaultMediaManager.INSTANCE.openVideo(fileName, ImageType.single(GrayU8.class));
        app.process(sequence);
    }
}

