/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.tracker;

import boofcv.gui.StandardAlgConfigPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JTextArea;

public class TrackerQuadInfoPanel
extends StandardAlgConfigPanel
implements ActionListener {
    JTextArea displayFPS;
    JTextArea displayTracking;
    JButton buttonPlay;
    JButton buttonSelect;
    JButton buttonReset;
    Listener listener;

    public TrackerQuadInfoPanel(Listener listener) {
        this.listener = listener;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder(0));
        this.displayFPS = this.createTextInfo();
        this.displayTracking = this.createTextInfo();
        this.buttonPlay = new JButton("Start");
        this.buttonPlay.addActionListener(this);
        this.buttonSelect = new JButton("Select");
        this.buttonSelect.addActionListener(this);
        this.buttonReset = new JButton("Reset");
        this.buttonReset.addActionListener(this);
        this.addLabeledV(this.displayFPS, "Algorithm FPS:", this);
        this.addLabeledV(this.displayTracking, "Tracking:", this);
        this.addSeparator(200);
        this.add(this.buttonPlay);
        this.addAlignCenter(this.buttonPlay, this);
        this.addAlignCenter(this.buttonReset, this);
        this.addSeparator(200);
        this.addAlignCenter(this.buttonSelect, this);
    }

    private JTextArea createTextInfo() {
        JTextArea comp = new JTextArea(1, 6);
        comp.setMaximumSize(comp.getPreferredSize());
        comp.setEditable(false);
        return comp;
    }

    public void setFPS(double fps) {
        this.displayFPS.setText(String.format("%5.1f", fps));
    }

    public void setTracking(String text) {
        this.displayTracking.setText(text);
    }

    public void setPlay(boolean playing) {
        if (playing) {
            this.buttonPlay.setText("Play");
        } else {
            this.buttonPlay.setText("Pause");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonPlay) {
            this.listener.togglePause();
        } else if (e.getSource() == this.buttonSelect) {
            this.listener.selectTarget();
        } else if (e.getSource() == this.buttonReset) {
            this.listener.resetVideo();
        }
    }

    public static interface Listener {
        public void togglePause();

        public void selectTarget();

        public void resetVideo();
    }
}

