/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.sfm.d3;

import boofcv.abst.feature.associate.AssociateDescTo2D;
import boofcv.abst.feature.associate.ScoreAssociateHamming_B;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.feature.tracker.PointTrackerToTwoPass;
import boofcv.abst.feature.tracker.PointTrackerTwoPass;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.DepthVisualOdometry;
import boofcv.alg.distort.DoNothingPixelTransform_F32;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.sfm.DepthSparse3D;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.demonstrations.sfm.d3.VisualOdometryPanel;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.feature.tracker.FactoryPointTracker;
import boofcv.factory.feature.tracker.FactoryPointTrackerTwoPass;
import boofcv.factory.sfm.FactoryVisualOdometry;
import boofcv.gui.DepthVideoAppBase;
import boofcv.gui.VisualizeApp;
import boofcv.gui.d3.Polygon3DSequenceViewer;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.ejml.data.DenseMatrix64F;

public class VisualizeDepthVisualOdometryApp<I extends ImageGray>
extends DepthVideoAppBase<I, GrayU16>
implements VisualizeApp,
VisualOdometryPanel.Listener {
    VisualOdometryPanel guiInfo;
    ImagePanel guiLeft;
    ImagePanel guiDepth;
    Polygon3DSequenceViewer guiCam3D;
    BufferedImage renderedDepth;
    DepthVisualOdometry<I, GrayU16> alg;
    boolean hasProcessedImage = false;
    boolean noFault;
    boolean showTracks;
    boolean showInliers;
    int numFaults;
    int numTracks;
    int numInliers;
    int whichAlg;

    public VisualizeDepthVisualOdometryApp(Class<I> imageType) {
        super(1, imageType, GrayU16.class);
        this.addAlgorithm(0, "Single P3P : KLT", 0);
        this.addAlgorithm(0, "Single P3P : ST-BRIEF", 1);
        this.addAlgorithm(0, "Single P3P : ST-SURF-KLT", 2);
        this.guiInfo = new VisualOdometryPanel(VisualOdometryPanel.Type.DEPTH);
        this.guiLeft = new ImagePanel();
        this.guiDepth = new ImagePanel();
        this.guiCam3D = new Polygon3DSequenceViewer();
        this.add((Component)this.guiInfo, "West");
        this.add((Component)this.guiDepth, "East");
        this.setMainGUI(this.guiLeft);
        this.guiLeft.addMouseListener(this);
        this.guiInfo.setListener(this);
    }

    private void drawFeatures(AccessPointTracks3D tracker, BufferedImage image) {
        this.numInliers = 0;
        Graphics2D g2 = image.createGraphics();
        List<Point2D_F64> points = tracker.getAllTracks();
        if (points.size() == 0) {
            return;
        }
        double[] ranges = new double[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            ranges[i] = tracker.getTrackLocation((int)i).z;
        }
        Arrays.sort(ranges);
        double maxRange = ranges[(int)((double)ranges.length * 0.8)];
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 pixel = points.get(i);
            if (this.showTracks && tracker.isNew(i)) {
                VisualizeFeatures.drawPoint(g2, (int)pixel.x, (int)pixel.y, 3, Color.GREEN);
                continue;
            }
            if (tracker.isInlier(i)) {
                if (this.showInliers) {
                    VisualizeFeatures.drawPoint(g2, (int)pixel.x, (int)pixel.y, 7, Color.BLUE, false);
                }
                ++this.numInliers;
            }
            if (!this.showTracks) continue;
            Point3D_F64 p3 = tracker.getTrackLocation(i);
            double r = p3.z / maxRange;
            if (r < 0.0) {
                r = 0.0;
            } else if (r > 1.0) {
                r = 1.0;
            }
            int color = 0xFF0000 | (int)(255.0 * r) << 8;
            VisualizeFeatures.drawPoint(g2, (int)pixel.x, (int)pixel.y, 3, new Color(color));
        }
        this.numTracks = points.size();
    }

    @Override
    protected void process(SimpleImageSequence<I> sequence1, SimpleImageSequence<GrayU16> sequence2) {
        this.stopWorker();
        sequence1.setLoop(false);
        sequence2.setLoop(false);
        this.sequence1 = sequence1;
        this.sequence2 = sequence2;
        this.doRefreshAll();
    }

    @Override
    protected void updateAlg(I frame1, BufferedImage buffImage1, GrayU16 frame2, BufferedImage buffImage2) {
        if (this.config.visualParam.width != ((ImageGray)frame1).width || this.config.visualParam.height != ((ImageGray)frame1).height) {
            throw new IllegalArgumentException("Miss match between calibration and actual image size");
        }
        this.noFault = this.alg.process(frame1, frame2);
        if (!this.noFault) {
            this.alg.reset();
            this.guiCam3D.init();
        }
    }

    @Override
    protected void updateAlgGUI(I frame1, final BufferedImage buffImage1, GrayU16 frame2, BufferedImage buffImage2, final double fps) {
        if (!this.noFault) {
            ++this.numFaults;
            return;
        }
        this.showTracks = this.guiInfo.isShowAll();
        this.showInliers = this.guiInfo.isShowInliers();
        if (this.renderedDepth == null) {
            this.renderedDepth = new BufferedImage(frame2.width, frame2.height, 1);
        }
        this.drawFeatures((AccessPointTracks3D)((Object)this.alg), buffImage1);
        final Se3_F64 leftToWorld = ((Se3_F64)this.alg.getCameraToWorld()).copy();
        VisualizeImageData.disparity((ImageGray)frame2, this.renderedDepth, 0, 10000, 0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeDepthVisualOdometryApp.this.guiLeft.setBufferedImage(buffImage1);
                VisualizeDepthVisualOdometryApp.this.guiDepth.setBufferedImage(VisualizeDepthVisualOdometryApp.this.renderedDepth);
                VisualizeDepthVisualOdometryApp.this.guiLeft.autoSetPreferredSize();
                VisualizeDepthVisualOdometryApp.this.guiDepth.autoSetPreferredSize();
                VisualizeDepthVisualOdometryApp.this.guiLeft.repaint();
                VisualizeDepthVisualOdometryApp.this.guiDepth.repaint();
                VisualizeDepthVisualOdometryApp.this.guiInfo.setCameraToWorld(leftToWorld);
                VisualizeDepthVisualOdometryApp.this.guiInfo.setNumFaults(VisualizeDepthVisualOdometryApp.this.numFaults);
                VisualizeDepthVisualOdometryApp.this.guiInfo.setNumTracks(VisualizeDepthVisualOdometryApp.this.numTracks);
                VisualizeDepthVisualOdometryApp.this.guiInfo.setNumInliers(VisualizeDepthVisualOdometryApp.this.numInliers);
                VisualizeDepthVisualOdometryApp.this.guiInfo.setFps(fps);
            }
        });
        double r = 0.15;
        Point3D_F64 p1 = new Point3D_F64(-r, -r, 0.0);
        Point3D_F64 p2 = new Point3D_F64(r, -r, 0.0);
        Point3D_F64 p3 = new Point3D_F64(r, r, 0.0);
        Point3D_F64 p4 = new Point3D_F64(-r, r, 0.0);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p1, (Point3D_F64)p1);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p2, (Point3D_F64)p2);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p3, (Point3D_F64)p3);
        SePointOps_F64.transform((Se3_F64)leftToWorld, (Point3D_F64)p4, (Point3D_F64)p4);
        this.guiCam3D.add(p1, p2, p3, p4);
        this.guiCam3D.repaint();
        this.hasProcessedImage = true;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.numFaults = 0;
        if (cookies != null) {
            this.whichAlg = (Integer)cookies[0];
        }
        this.alg = this.createVisualOdometry(this.whichAlg);
        this.alg.setCalibration(this.config.visualParam, new DoNothingPixelTransform_F32());
        this.guiInfo.reset();
        this.handleRunningStatus(2);
        DenseMatrix64F K = PerspectiveOps.calibrationMatrix(this.config.visualParam, null);
        this.guiCam3D.init();
        this.guiCam3D.setK(K);
        this.guiCam3D.setStepSize(0.05);
        this.guiCam3D.setPreferredSize(new Dimension(this.config.visualParam.width, this.config.visualParam.height));
        this.guiCam3D.setMaximumSize(this.guiCam3D.getPreferredSize());
        this.startWorkerThread();
    }

    private DepthVisualOdometry<I, GrayU16> createVisualOdometry(int whichAlg) {
        Class derivType = GImageDerivativeOps.getDerivativeType(this.imageType);
        DepthSparse3D.I sparseDepth = new DepthSparse3D.I(0.001);
        PkltConfig pkltConfig = new PkltConfig();
        pkltConfig.templateRadius = 3;
        pkltConfig.pyramidScaling = new int[]{1, 2, 4, 8};
        if (whichAlg == 0) {
            ConfigGeneralDetector configDetector = new ConfigGeneralDetector(600, 3, 1.0f);
            PointTrackerTwoPass tracker = FactoryPointTrackerTwoPass.klt(pkltConfig, configDetector, this.imageType, derivType);
            return FactoryVisualOdometry.depthDepthPnP(1.5, 120, 2, 200, 50, false, sparseDepth, tracker, this.imageType, GrayU16.class);
        }
        if (whichAlg == 1) {
            ConfigGeneralDetector configExtract = new ConfigGeneralDetector(600, 3, 1.0f);
            GeneralFeatureDetector detector = FactoryPointTracker.createShiTomasi(configExtract, derivType);
            DescribeRegionPoint describe = FactoryDescribeRegionPoint.brief(null, this.imageType);
            ScoreAssociateHamming_B score = new ScoreAssociateHamming_B();
            AssociateDescTo2D<TupleDesc_B> associate = new AssociateDescTo2D<TupleDesc_B>(FactoryAssociation.greedy(score, 150.0, true));
            PointTrackerTwoPass tracker = FactoryPointTrackerTwoPass.dda(detector, describe, associate, null, 1.0, this.imageType);
            return FactoryVisualOdometry.depthDepthPnP(1.5, 80, 3, 200, 50, false, sparseDepth, tracker, this.imageType, GrayU16.class);
        }
        if (whichAlg == 2) {
            PointTracker tracker = FactoryPointTracker.combined_ST_SURF_KLT(new ConfigGeneralDetector(600, 3, 1.0f), pkltConfig, 50, null, null, this.imageType, derivType);
            PointTrackerToTwoPass twopass = new PointTrackerToTwoPass(tracker);
            return FactoryVisualOdometry.depthDepthPnP(1.5, 120, 3, 200, 50, false, sparseDepth, twopass, this.imageType, GrayU16.class);
        }
        throw new RuntimeException("Unknown selection");
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.stopWorker();
        this.whichAlg = (Integer)cookie;
        this.sequence1.reset();
        this.sequence2.reset();
        this.refreshAll(null);
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.hasProcessedImage;
    }

    @Override
    protected void handleRunningStatus(int status) {
        Color color;
        String text;
        switch (status) {
            case 0: {
                text = "RUNNING";
                color = Color.BLACK;
                break;
            }
            case 1: {
                text = "PAUSED";
                color = Color.RED;
                break;
            }
            case 2: {
                text = "FINISHED";
                color = Color.RED;
                break;
            }
            default: {
                text = "UNKNOWN";
                color = Color.BLUE;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeDepthVisualOdometryApp.this.guiInfo.setStatus(text, color);
            }
        });
    }

    @Override
    public void eventVoPanel(final int view) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (view == 0) {
                    VisualizeDepthVisualOdometryApp.this.remove(VisualizeDepthVisualOdometryApp.this.guiCam3D);
                    VisualizeDepthVisualOdometryApp.this.add((Component)VisualizeDepthVisualOdometryApp.this.guiDepth, "East");
                } else {
                    VisualizeDepthVisualOdometryApp.this.remove(VisualizeDepthVisualOdometryApp.this.guiDepth);
                    VisualizeDepthVisualOdometryApp.this.add((Component)VisualizeDepthVisualOdometryApp.this.guiCam3D, "East");
                }
                VisualizeDepthVisualOdometryApp.this.revalidate();
                VisualizeDepthVisualOdometryApp.this.repaint();
            }
        });
    }

    public static void main(String[] args) throws FileNotFoundException {
        Class<GrayF32> type = GrayF32.class;
        VisualizeDepthVisualOdometryApp<GrayF32> app = new VisualizeDepthVisualOdometryApp<GrayF32>(type);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Circle", UtilIO.pathExample("kinect/circle/config.txt")));
        inputs.add(new PathLabel("Hallway", UtilIO.pathExample("kinect/straight/config.txt")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Depth Visual Odometry", true);
    }
}

