/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.sfm.d3;

import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.d3.Orientation3D;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.ejml.data.DenseMatrix64F;

public class VisualOdometryPanel
extends StandardAlgConfigPanel
implements ItemListener,
ActionListener {
    JLabel displayStatus;
    JComboBox selectView;
    JTextArea displayX;
    JTextArea displayY;
    JTextArea displayZ;
    Orientation3D orientation = new Orientation3D();
    JTextArea displayIntegral;
    JTextArea displayOrigin;
    JTextArea displayTracks;
    JTextArea displayInliers;
    JTextArea displayFaults;
    JTextArea displayFps;
    JCheckBox showAll;
    JCheckBox showInliers;
    boolean setShowAll = true;
    boolean setShowInliers = false;
    Se3_F64 prevToWorld;
    double integral;
    Listener listener;

    public VisualOdometryPanel(Type type) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder(0));
        this.displayStatus = new JLabel();
        this.displayStatus.setFont(new Font("Dialog", 1, 16));
        if (type == Type.STEREO) {
            this.selectView = new JComboBox<String>(new String[]{"Right", "3D"});
        } else if (type == Type.DEPTH) {
            this.selectView = new JComboBox<String>(new String[]{"Depth", "3D"});
        } else if (type == Type.MONO_PLANE) {
            this.selectView = new JComboBox<String>(new String[]{"2D", "3D"});
        }
        this.selectView.addActionListener(this);
        this.selectView.setMaximumSize(this.selectView.getPreferredSize());
        this.displayX = this.createTextInfo();
        this.displayY = this.createTextInfo();
        this.displayZ = this.createTextInfo();
        this.showAll = new JCheckBox("Show All");
        this.showAll.addItemListener(this);
        this.showAll.setSelected(this.setShowAll);
        this.showInliers = new JCheckBox("Show Inliers");
        this.showInliers.addItemListener(this);
        this.showInliers.setSelected(this.setShowInliers);
        this.displayIntegral = this.createTextInfo();
        this.displayOrigin = this.createTextInfo();
        this.displayTracks = this.createTextInfo();
        this.displayInliers = this.createTextInfo();
        this.displayFaults = this.createTextInfo();
        this.displayFps = this.createTextInfo();
        this.addAlignCenter(this.displayStatus, this);
        this.addLabeled(this.selectView, "View", this);
        this.addSeparator(150);
        this.addLabeled(this.displayTracks, "Tracks", this);
        this.addLabeled(this.displayInliers, "Inliers", this);
        this.addLabeled(this.displayFaults, "Faults", this);
        this.addLabeled(this.displayFps, "FPS", this);
        this.addSeparator(150);
        this.addLabeled(this.displayX, "X ", this);
        this.addLabeled(this.displayY, "Y ", this);
        this.addLabeled(this.displayZ, "Z ", this);
        this.addAlignCenter(this.orientation, this);
        this.addSeparator(150);
        this.addLabeled(this.displayIntegral, "Integral", this);
        this.addLabeled(this.displayOrigin, "Origin", this);
        this.addSeparator(150);
        this.addAlignLeft(this.showAll, this);
        this.addAlignLeft(this.showInliers, this);
        this.addVerticalGlue(this);
    }

    public void reset() {
        this.prevToWorld = null;
        this.integral = 0.0;
    }

    private JTextArea createTextInfo() {
        JTextArea comp = new JTextArea(1, 6);
        comp.setMaximumSize(comp.getPreferredSize());
        comp.setEditable(false);
        return comp;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() == this.showInliers) {
            this.setShowInliers = e.getStateChange() != 2;
        } else if (e.getItem() == this.showAll) {
            this.setShowAll = e.getStateChange() != 2;
        }
    }

    public void setCameraToWorld(Se3_F64 cameraToWorld) {
        this.displayX.setText(String.format("%6.1f", cameraToWorld.getT().x));
        this.displayY.setText(String.format("%6.1f", cameraToWorld.getT().y));
        this.displayZ.setText(String.format("%6.1f", cameraToWorld.getT().z));
        Vector3D_F64 v = new Vector3D_F64(0.0, 0.0, 1.0);
        GeometryMath_F64.mult((DenseMatrix64F)cameraToWorld.getR(), (GeoTuple3D_F64)v, (GeoTuple3D_F64)v);
        this.orientation.setVector(v);
        this.orientation.repaint();
        this.displayOrigin.setText(String.format("%6.1f", cameraToWorld.getT().norm()));
        if (this.prevToWorld == null) {
            this.prevToWorld = cameraToWorld.copy();
        } else {
            Se3_F64 worldToPrev = this.prevToWorld.invert(null);
            cameraToWorld.concat(worldToPrev, this.prevToWorld);
            this.integral += this.prevToWorld.getT().norm();
            this.prevToWorld.set(cameraToWorld);
        }
        this.displayIntegral.setText(String.format("%6.1f", this.integral));
    }

    public void setStatus(String text, Color color) {
        this.displayStatus.setText(text);
        this.displayStatus.setForeground(color);
    }

    public void setNumTracks(int totalTracks) {
        this.displayTracks.setText(String.format("%5d", totalTracks));
    }

    public void setNumInliers(int totalInliers) {
        this.displayInliers.setText(String.format("%5d", totalInliers));
    }

    public void setNumFaults(int totalFaults) {
        this.displayFaults.setText(String.format("%5d", totalFaults));
    }

    public void setFps(double fps) {
        this.displayFps.setText(String.format("%6.1f", fps));
    }

    public boolean isShowAll() {
        return this.setShowAll;
    }

    public boolean isShowInliers() {
        return this.setShowInliers;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectView && this.listener != null) {
            this.listener.eventVoPanel(this.selectView.getSelectedIndex());
        }
    }

    public static enum Type {
        STEREO,
        DEPTH,
        MONO_PLANE;

    }

    public static interface Listener {
        public void eventVoPanel(int var1);
    }
}

