/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.orientation;

import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.orientation.ConfigAverageIntegral;
import boofcv.abst.feature.orientation.ConfigSlidingIntegral;
import boofcv.abst.feature.orientation.OrientationGradient;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.abst.feature.orientation.RegionOrientation;
import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.feature.orientation.OrientationImageAverage;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.FancyInterestPointRender;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I16;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class ShowFeatureOrientationApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel {
    ImagePanel panel;
    static int NUM_FEATURES = 500;
    int radius = 10;
    BufferedImage input;
    Class<T> imageType;
    Class<D> derivType;
    boolean hasProcessed = false;

    public ShowFeatureOrientationApp(Class<T> imageType, Class<D> derivType) {
        super(1);
        this.imageType = imageType;
        this.derivType = derivType;
        double objectToScale = 0.5;
        this.addAlgorithm(0, "Pixel", FactoryOrientationAlgs.nogradient(objectToScale, this.radius, imageType));
        this.addAlgorithm(0, "Gradient Average", FactoryOrientationAlgs.average(objectToScale, this.radius, false, derivType));
        this.addAlgorithm(0, "Gradient Average Weighted", FactoryOrientationAlgs.average(objectToScale, this.radius, true, derivType));
        this.addAlgorithm(0, "Gradient Histogram 10", FactoryOrientationAlgs.histogram(objectToScale, 10, this.radius, false, derivType));
        this.addAlgorithm(0, "Gradient Histogram 10 Weighted", FactoryOrientationAlgs.histogram(objectToScale, 10, this.radius, true, derivType));
        this.addAlgorithm(0, "Gradient Sliding", FactoryOrientationAlgs.sliding(objectToScale, 20, 1.0471975511965976, this.radius, false, derivType));
        this.addAlgorithm(0, "Gradient Sliding Weighted", FactoryOrientationAlgs.sliding(objectToScale, 20, 1.0471975511965976, this.radius, true, derivType));
        this.addAlgorithm(0, "Integral Average", FactoryOrientationAlgs.average_ii(new ConfigAverageIntegral(this.radius, 1.0, 4, 0.0), imageType));
        this.addAlgorithm(0, "Integral Average Weighted", FactoryOrientationAlgs.average_ii(new ConfigAverageIntegral(this.radius, 1.0, 4, -1.0), imageType));
        this.addAlgorithm(0, "Integral Sliding", FactoryOrientationAlgs.sliding_ii(new ConfigSlidingIntegral(1.0, 1.0, 4, 0.0, 4), imageType));
        this.addAlgorithm(0, "Integral Sliding Weighted", FactoryOrientationAlgs.sliding_ii(new ConfigSlidingIntegral(1.0, 1.0, 4, -1.0, 4), imageType));
        this.panel = new ImagePanel();
        this.setMainGUI(this.panel);
    }

    public synchronized void process(final BufferedImage input) {
        this.setInputImage(input);
        this.panel.setBufferedImage(input);
        this.input = input;
        this.doRefreshAll();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowFeatureOrientationApp.this.setPreferredSize(new Dimension(input.getWidth(), input.getHeight()));
                ShowFeatureOrientationApp.this.setSize(input.getWidth(), input.getHeight());
                ShowFeatureOrientationApp.this.hasProcessed = true;
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public synchronized void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.input == null) {
            return;
        }
        RegionOrientation orientation = (RegionOrientation)cookie;
        orientation.setObjectRadius(10.0);
        Object workImage = ConvertBufferedImage.convertFromSingle(this.input, null, this.imageType);
        AnyImageDerivative<T, D> deriv = GImageDerivativeOps.derivativeForScaleSpace(this.imageType, this.derivType);
        deriv.setInput(workImage);
        int r = 2;
        GeneralFeatureDetector detector = FactoryDetectPoint.createHarris(new ConfigGeneralDetector(NUM_FEATURES, r, 1.0f), false, this.derivType);
        Object derivX = null;
        Object derivY = null;
        Object derivXX = null;
        Object derivYY = null;
        Object derivXY = null;
        if (detector.getRequiresGradient()) {
            derivX = deriv.getDerivative(true);
            derivY = deriv.getDerivative(false);
        } else if (detector.getRequiresHessian()) {
            derivXX = deriv.getDerivative(true, true);
            derivYY = deriv.getDerivative(false, false);
            derivXY = deriv.getDerivative(true, false);
        }
        detector.process(workImage, derivX, derivY, derivXX, derivYY, derivXY);
        QueueCorner points = detector.getMaximums();
        FancyInterestPointRender render = new FancyInterestPointRender();
        if (orientation instanceof OrientationGradient) {
            ((OrientationGradient)orientation).setImage(deriv.getDerivative(true), deriv.getDerivative(false));
        } else if (orientation instanceof OrientationIntegral) {
            Object ii = GIntegralImageOps.transform(workImage, null);
            ((OrientationIntegral)orientation).setImage(ii);
        } else if (orientation instanceof OrientationImageAverage) {
            ((OrientationImageAverage)orientation).setImage(workImage);
        } else {
            throw new IllegalArgumentException("Unknown algorithm type.");
        }
        for (int i = 0; i < points.size; ++i) {
            Point2D_I16 p = (Point2D_I16)points.get(i);
            double angle = orientation.compute(p.x, p.y);
            render.addCircle(p.x, p.y, this.radius, Color.RED, angle);
        }
        BufferedImage temp = new BufferedImage(this.input.getWidth(), this.input.getHeight(), this.input.getType());
        Graphics2D g2 = (Graphics2D)temp.getGraphics();
        g2.drawImage((Image)this.input, 0, 0, null);
        g2.setStroke(new BasicStroke(2.5f));
        render.draw(g2);
        this.panel.setBufferedImage(temp);
        this.panel.repaint();
    }

    @Override
    public synchronized void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.hasProcessed;
    }

    public static void main(String[] args) {
        ShowFeatureOrientationApp<GrayF32, GrayF32> app = new ShowFeatureOrientationApp<GrayF32, GrayF32>(GrayF32.class, GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        inputs.add(new PathLabel("beach", UtilIO.pathExample("scale/beach02.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        System.out.println("Calling show window");
        ShowImages.showWindow(app, "Feature Orientation", true);
        System.out.println("Done");
    }
}

