/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointScaleSpacePyramid;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.feature.detect.interest.FactoryInterestPointAlgs;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.ScaleSpacePyramidPointPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidFloat;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class DetectFeaturePyramidApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel {
    static int NUM_FEATURES = 100;
    PyramidFloat<T> ss;
    Class<T> imageType;
    ScaleSpacePyramidPointPanel panel;
    boolean hasImage = false;
    T workImage;
    InterestPointScaleSpacePyramid<T> det = null;

    public DetectFeaturePyramidApp(Class<T> imageType, Class<D> derivType) {
        super(2);
        this.imageType = imageType;
        this.workImage = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        int r = 2;
        this.addAlgorithm(0, "Hessian Laplace", FactoryInterestPointAlgs.hessianLaplace(r, 0.0f, NUM_FEATURES, imageType, derivType));
        this.addAlgorithm(0, "Harris Laplace", FactoryInterestPointAlgs.harrisLaplace(r, 0.0f, NUM_FEATURES, imageType, derivType));
        this.addAlgorithm(0, "Hessian", FactoryInterestPointAlgs.hessianPyramid(r, 0.0f, NUM_FEATURES, imageType, derivType));
        this.addAlgorithm(0, "Harris", FactoryInterestPointAlgs.harrisPyramid(r, 0.0f, NUM_FEATURES, imageType, derivType));
        this.addAlgorithm(1, "Pyramid", 0);
        this.addAlgorithm(1, "Scale-Space", 1);
        this.panel = new ScaleSpacePyramidPointPanel(2.5);
        this.setMainGUI(this.panel);
    }

    public synchronized void process(BufferedImage input) {
        this.setInputImage(input);
        ((ImageGray)this.workImage).reshape(input.getWidth(), input.getHeight());
        ConvertBufferedImage.convertFromSingle(input, this.workImage, this.imageType);
        this.panel.setBackground(input);
        this.hasImage = true;
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.det = null;
        this.ss = null;
        this.setActiveAlgorithm(0, null, cookies[0]);
        this.setActiveAlgorithm(1, null, cookies[1]);
    }

    @Override
    public synchronized void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (!this.hasImage) {
            return;
        }
        if (indexFamily == 0) {
            this.det = (InterestPointScaleSpacePyramid)cookie;
            if (this.ss == null) {
                return;
            }
        } else {
            double[] scales = new double[]{1.0, 1.5, 2.0, 3.0, 4.0, 8.0, 12.0, 16.0, 24.0};
            this.ss = ((Number)cookie).intValue() == 0 ? FactoryPyramid.scaleSpacePyramid(scales, this.imageType) : FactoryPyramid.scaleSpace(scales, this.imageType);
            if (this.workImage != null) {
                this.ss.process(this.workImage);
            }
            this.panel.setSs(this.ss);
            if (this.det == null) {
                return;
            }
        }
        this.det.detect(this.ss);
        this.panel.setPoints(this.det.getInterestPoints());
        this.panel.repaint();
        this.panel.requestFocusInWindow();
    }

    @Override
    public synchronized void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.hasImage;
    }

    public static void main(String[] args) {
        DetectFeaturePyramidApp<GrayF32, GrayF32> app = new DetectFeaturePyramidApp<GrayF32, GrayF32>(GrayF32.class, GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("amoeba", UtilIO.pathExample("amoeba_shapes.jpg")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        inputs.add(new PathLabel("beach", UtilIO.pathExample("scale/beach02.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Feature Pyramid", true);
    }
}

