/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect;

import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.alg.feature.orientation.OrientationImageAverage;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.gui.feature.FancyInterestPointRender;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ProcessImageSequence;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.video.BoofVideoManager;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class VideoDetectInterestPoints<T extends ImageGray>
extends ProcessImageSequence<T> {
    InterestPointDetector<T> detector;
    OrientationImageAverage<T> orientation;
    FancyInterestPointRender render = new FancyInterestPointRender();
    ImagePanel panel;

    public VideoDetectInterestPoints(SimpleImageSequence<T> sequence, InterestPointDetector<T> detector, OrientationImageAverage<T> orientation) {
        super(sequence);
        this.detector = detector;
        this.orientation = orientation;
    }

    @Override
    public void processFrame(T image) {
        this.detector.detect(image);
    }

    @Override
    public void updateGUI(BufferedImage guiImage, T origImage) {
        Graphics2D g2 = guiImage.createGraphics();
        if (this.orientation != null) {
            this.orientation.setImage(origImage);
        }
        this.render.reset();
        for (int i = 0; i < this.detector.getNumberOfFeatures(); ++i) {
            Point2D_F64 pt = this.detector.getLocation(i);
            int radius = (int)Math.round(this.detector.getRadius(i));
            if (this.orientation != null) {
                this.orientation.setObjectRadius(radius);
                double angle = this.orientation.compute(pt.x, pt.y);
                this.render.addCircle((int)pt.x, (int)pt.y, radius, Color.red, angle);
                continue;
            }
            this.render.addCircle((int)pt.x, (int)pt.y, radius);
        }
        this.render.draw(g2);
        if (this.panel == null) {
            this.panel = ShowImages.showWindow(guiImage, "Image Sequence");
            this.addComponent(this.panel);
        } else {
            this.panel.setBufferedImage(guiImage);
            this.panel.repaint();
        }
    }

    public static <T extends ImageGray, D extends ImageGray> void perform(String fileName, Class<T> imageType, Class<D> derivType) {
        SimpleImageSequence<T> sequence = BoofVideoManager.loadManagerDefault().load(fileName, ImageType.single(imageType));
        int maxCorners = 200;
        int radius = 2;
        OrientationImageAverage<T> orientation = null;
        orientation = FactoryOrientationAlgs.nogradient(0.5, radius, imageType);
        InterestPointDetector detector = FactoryInterestPoint.fastHessian(new ConfigFastHessian(1.0f, 2, 100, 2, 9, 4, 4));
        VideoDetectInterestPoints<T> display = new VideoDetectInterestPoints<T>(sequence, detector, orientation);
        display.process();
    }

    public static void main(String[] args) {
        String fileName = args.length == 0 ? UtilIO.pathExample("zoom.mjpeg") : args[0];
        VideoDetectInterestPoints.perform(fileName, GrayF32.class, GrayF32.class);
    }
}

