/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.associate;

import boofcv.abst.feature.describe.ConfigBrief;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.detect.interest.ConfigSiftDetector;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.demonstrations.feature.associate.VisualizeScorePanel;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.factory.feature.orientation.FactoryOrientation;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.AssociationScorePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class VisualizeAssociationScoreApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements VisualizeScorePanel.Listener {
    InterestPointDetector<T> detector;
    DescribeRegionPoint<T, TupleDesc> describe;
    OrientationImage<T> orientation;
    T imageLeft;
    T imageRight;
    Class<T> imageType;
    AssociationScorePanel<TupleDesc> scorePanel;
    VisualizeScorePanel controlPanel;
    boolean processedImage = false;

    public VisualizeAssociationScoreApp(Class<T> imageType, Class<D> derivType) {
        super(2);
        this.imageType = imageType;
        this.imageLeft = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.imageRight = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.addAlgorithm(0, "Fast Hessian", FactoryInterestPoint.fastHessian(new ConfigFastHessian(1.0f, 2, 200, 1, 9, 4, 4)));
        this.addAlgorithm(0, "SIFT", FactoryInterestPoint.sift(null, new ConfigSiftDetector(500), imageType));
        GeneralFeatureDetector alg = FactoryDetectPoint.createShiTomasi(new ConfigGeneralDetector(500, 2, 1.0f), false, derivType);
        this.addAlgorithm(0, "Shi-Tomasi", FactoryInterestPoint.wrapPoint(alg, 1.0, imageType, derivType));
        this.addAlgorithm(1, "SURF", FactoryDescribeRegionPoint.surfStable(null, imageType));
        this.addAlgorithm(1, "SIFT", FactoryDescribeRegionPoint.sift(null, null, imageType));
        this.addAlgorithm(1, "BRIEF", FactoryDescribeRegionPoint.brief(new ConfigBrief(true), imageType));
        this.addAlgorithm(1, "BRIEFO", FactoryDescribeRegionPoint.brief(new ConfigBrief(false), imageType));
        this.addAlgorithm(1, "Pixel 11x11", FactoryDescribeRegionPoint.pixel(11, 11, imageType));
        this.addAlgorithm(1, "NCC 11x11", FactoryDescribeRegionPoint.pixelNCC(11, 11, imageType));
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        OrientationIntegral orientationII = FactoryOrientationAlgs.sliding_ii(null, integralType);
        this.orientation = FactoryOrientation.convertImage(orientationII, imageType);
        this.controlPanel = new VisualizeScorePanel(this);
        this.scorePanel = new AssociationScorePanel(3.0);
        JPanel gui = new JPanel();
        gui.setLayout(new BorderLayout());
        gui.add((Component)this.controlPanel, "West");
        gui.add(this.scorePanel, "Center");
        this.setMainGUI(gui);
    }

    public void process(BufferedImage buffLeft, BufferedImage buffRight) {
        ((ImageGray)this.imageLeft).reshape(buffLeft.getWidth(), buffLeft.getHeight());
        ((ImageGray)this.imageRight).reshape(buffRight.getWidth(), buffRight.getHeight());
        ConvertBufferedImage.convertFromSingle(buffLeft, this.imageLeft, this.imageType);
        ConvertBufferedImage.convertFromSingle(buffRight, this.imageRight, this.imageType);
        this.scorePanel.setImages(buffLeft, buffRight);
        this.processedImage = true;
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.detector = (InterestPointDetector)cookies[0];
        this.describe = (DescribeRegionPoint)cookies[1];
        this.controlPanel.setFeatureType(this.describe.getDescriptionType());
        this.processImage();
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        switch (indexFamily) {
            case 0: {
                this.detector = (InterestPointDetector)cookie;
                break;
            }
            case 1: {
                this.describe = (DescribeRegionPoint)cookie;
            }
        }
        this.controlPanel.setFeatureType(this.describe.getDescriptionType());
        this.processImage();
    }

    private void processImage() {
        final ArrayList<Point2D_F64> leftPts = new ArrayList<Point2D_F64>();
        final ArrayList<Point2D_F64> rightPts = new ArrayList<Point2D_F64>();
        final ArrayList<TupleDesc> leftDesc = new ArrayList<TupleDesc>();
        final ArrayList<TupleDesc> rightDesc = new ArrayList<TupleDesc>();
        final ProgressMonitor progressMonitor = new ProgressMonitor(this, "Compute Feature Information", "", 0, 4);
        this.extractImageFeatures(progressMonitor, 0, this.imageLeft, leftDesc, leftPts);
        this.extractImageFeatures(progressMonitor, 2, this.imageRight, rightDesc, rightPts);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressMonitor.close();
                VisualizeAssociationScoreApp.this.scorePanel.setScorer(VisualizeAssociationScoreApp.this.controlPanel.getSelected());
                VisualizeAssociationScoreApp.this.scorePanel.setLocation(leftPts, rightPts, leftDesc, rightDesc);
                VisualizeAssociationScoreApp.this.repaint();
            }
        });
    }

    private void extractImageFeatures(final ProgressMonitor progressMonitor, final int progress, T image, List<TupleDesc> descs, List<Point2D_F64> locs) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressMonitor.setNote("Detecting");
            }
        });
        this.detector.detect(image);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressMonitor.setProgress(progress + 1);
                progressMonitor.setNote("Describing");
            }
        });
        this.describe.setImage(image);
        this.orientation.setImage(image);
        if (this.detector.hasScale()) {
            for (int i = 0; i < this.detector.getNumberOfFeatures(); ++i) {
                Object d;
                double yaw = 0.0;
                Point2D_F64 pt = this.detector.getLocation(i);
                double radius = this.detector.getRadius(i);
                if (this.describe.requiresOrientation()) {
                    this.orientation.setObjectRadius(radius);
                    yaw = this.orientation.compute(pt.x, pt.y);
                }
                if (!this.describe.process(pt.x, pt.y, yaw, radius, (TupleDesc)(d = this.describe.createDescription()))) continue;
                descs.add((TupleDesc)d);
                locs.add(pt.copy());
            }
        } else {
            this.orientation.setObjectRadius(1.0);
            for (int i = 0; i < this.detector.getNumberOfFeatures(); ++i) {
                Object d;
                double yaw = 0.0;
                Point2D_F64 pt = this.detector.getLocation(i);
                if (this.describe.requiresOrientation()) {
                    yaw = this.orientation.compute(pt.x, pt.y);
                }
                if (!this.describe.process(pt.x, pt.y, yaw, 1.0, (TupleDesc)(d = this.describe.createDescription()))) continue;
                descs.add((TupleDesc)d);
                locs.add(pt.copy());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressMonitor.setProgress(progress + 2);
            }
        });
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage left = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath(0));
        BufferedImage right = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath(1));
        this.process(left, right);
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public void changedSetting() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeAssociationScoreApp.this.scorePanel.setScorer(VisualizeAssociationScoreApp.this.controlPanel.getSelected());
                VisualizeAssociationScoreApp.this.repaint();
            }
        });
    }

    public static void main(String[] args) {
        Class<GrayF32> imageType = GrayF32.class;
        Class<GrayF32> derivType = GrayF32.class;
        VisualizeAssociationScoreApp<GrayF32, GrayF32> app = new VisualizeAssociationScoreApp<GrayF32, GrayF32>(imageType, derivType);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Cave", UtilIO.pathExample("stitch/cave_01.jpg"), UtilIO.pathExample("stitch/cave_02.jpg")));
        inputs.add(new PathLabel("Kayak", UtilIO.pathExample("stitch/kayak_02.jpg"), UtilIO.pathExample("stitch/kayak_03.jpg")));
        inputs.add(new PathLabel("Forest", UtilIO.pathExample("scale/rainforest_01.jpg"), UtilIO.pathExample("scale/rainforest_02.jpg")));
        inputs.add(new PathLabel("Building", UtilIO.pathExample("stitch/apartment_building_01.jpg"), UtilIO.pathExample("stitch/apartment_building_02.jpg")));
        inputs.add(new PathLabel("Trees Rotate", UtilIO.pathExample("stitch/trees_rotate_01.jpg"), UtilIO.pathExample("stitch/trees_rotate_03.jpg")));
        app.setPreferredSize(new Dimension(1000, 500));
        app.setSize(1000, 500);
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Association Relative Score", true);
    }
}

