/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.enhance;

import boofcv.alg.enhance.EnhanceImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayU8;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageEnhanceApp
extends SelectAlgorithmAndInputPanel
implements ChangeListener {
    ImagePanel gui;
    GrayU8 input;
    GrayU8 enhanced = new GrayU8(1, 1);
    boolean processImage = false;
    BufferedImage output;
    int[] histogram = new int[256];
    int[] transform = new int[256];
    JSpinner selectRadius;
    int radius = 50;
    int previousActive = -1;

    public ImageEnhanceApp() {
        super(1);
        this.addAlgorithm(0, "Histogram Global", 0);
        this.addAlgorithm(0, "Histogram Local", 1);
        this.addAlgorithm(0, "Sharpen-4", 2);
        this.addAlgorithm(0, "Sharpen-8", 3);
        this.selectRadius = new JSpinner(new SpinnerNumberModel(this.radius, 10, 100, 10));
        this.selectRadius.addChangeListener(this);
        this.gui = new ImagePanel();
        this.setMainGUI(this.gui);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.input == null) {
            return;
        }
        int active = (Integer)cookie;
        if (active == 0) {
            ImageStatistics.histogram(this.input, this.histogram);
            EnhanceImageOps.equalize(this.histogram, this.transform);
            EnhanceImageOps.applyTransform(this.input, this.transform, this.enhanced);
        } else if (active == 1) {
            EnhanceImageOps.equalizeLocal(this.input, this.radius, this.enhanced, this.histogram, this.transform);
        } else if (active == 2) {
            EnhanceImageOps.sharpen4(this.input, this.enhanced);
        } else if (active == 3) {
            EnhanceImageOps.sharpen8(this.input, this.enhanced);
        }
        if (this.previousActive != active) {
            if (active == 1) {
                this.addToToolbar(this.selectRadius);
            } else {
                this.removeFromToolbar(this.selectRadius);
            }
            this.previousActive = active;
        }
        ConvertBufferedImage.convertTo(this.enhanced, this.output);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageEnhanceApp.this.gui.setBufferedImage(ImageEnhanceApp.this.output);
                ImageEnhanceApp.this.gui.repaint();
                ImageEnhanceApp.this.gui.requestFocusInWindow();
            }
        });
    }

    public void process(final BufferedImage input) {
        this.setInputImage(input);
        this.input = ConvertBufferedImage.convertFromSingle(input, this.input, GrayU8.class);
        this.enhanced = new GrayU8(input.getWidth(), input.getHeight());
        this.output = new BufferedImage(input.getWidth(), input.getHeight(), 1);
        ConvertBufferedImage.convertTo(this.input, input);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageEnhanceApp.this.setPreferredSize(new Dimension(input.getWidth(), input.getHeight()));
                ImageEnhanceApp.this.processImage = true;
            }
        });
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processImage;
    }

    public static void main(String[] args) {
        ImageEnhanceApp app = new ImageEnhanceApp();
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("dark", UtilIO.pathExample("enhance/dark.jpg")));
        inputs.add(new PathLabel("dull", UtilIO.pathExample("enhance/dull.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Image Enhancement", true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.radius = (Integer)this.selectRadius.getValue();
        this.doRefreshAll();
    }
}

