/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.denoise;

import boofcv.gui.StandardAlgConfigPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DenoiseInfoPanel
extends StandardAlgConfigPanel
implements ChangeListener,
ActionListener {
    JComboBox images;
    JSpinner noiseLevel;
    JPanel configHolder = new JPanel();
    JPanel waveletConfig;
    JComboBox waveletBox;
    JSpinner waveletLevel;
    JPanel blurConfig;
    JSpinner blurRadius;
    JTextArea algError;
    JTextArea algErrorEdge;
    JTextArea noiseError;
    JTextArea noiseErrorEdge;
    Listener listener;

    public DenoiseInfoPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder(0));
        this.images = new JComboBox();
        this.images.addItem("Denoised");
        this.images.addItem("Noisy");
        this.images.addItem("Original");
        this.images.addActionListener(this);
        this.images.setMaximumSize(this.images.getPreferredSize());
        this.waveletBox = new JComboBox();
        this.waveletBox.addActionListener(this);
        double h = this.waveletBox.getPreferredSize().getHeight();
        this.waveletBox.setMaximumSize(new Dimension(175, (int)h));
        this.noiseLevel = new JSpinner(new SpinnerNumberModel(20, 0, 100, 5));
        this.noiseLevel.addChangeListener(this);
        this.noiseLevel.setMaximumSize(this.noiseLevel.getPreferredSize());
        this.waveletLevel = new JSpinner(new SpinnerNumberModel(4, 1, 5, 1));
        this.waveletLevel.addChangeListener(this);
        this.waveletLevel.setMaximumSize(new Dimension(75, (int)h));
        this.blurRadius = new JSpinner(new SpinnerNumberModel(1, 1, 12, 1));
        this.blurRadius.addChangeListener(this);
        this.blurRadius.setMaximumSize(new Dimension(75, (int)h));
        this.algError = this.createErrorComponent();
        this.algErrorEdge = this.createErrorComponent();
        this.noiseError = this.createErrorComponent();
        this.noiseErrorEdge = this.createErrorComponent();
        this.configHolder.add(this.createWaveletConfig());
        this.createBlurConfig();
        this.addLabeled(this.images, "View", this);
        this.addLabeled(this.noiseLevel, "Noise", this);
        this.addSeparator(200);
        this.addCenterLabel("Denoised", this);
        this.addLabeled(this.algError, "Error", this);
        this.addLabeled(this.algErrorEdge, "Edge Error", this);
        this.addSeparator(200);
        this.addCenterLabel("Noise Image", this);
        this.addLabeled(this.noiseError, "Error", this);
        this.addLabeled(this.noiseErrorEdge, "Edge Error", this);
        this.addSeparator(200);
        this.add(this.configHolder);
        this.add(Box.createVerticalGlue());
    }

    private JPanel createWaveletConfig() {
        this.waveletConfig = new JPanel();
        this.waveletConfig.setLayout(new BoxLayout(this.waveletConfig, 1));
        this.addCenterLabel("Wavelet Config", this.waveletConfig);
        this.addLabeled(this.waveletBox, "Wavelet", this.waveletConfig);
        this.addLabeled(this.waveletLevel, "Level", this.waveletConfig);
        return this.waveletConfig;
    }

    private JPanel createBlurConfig() {
        this.blurConfig = new JPanel();
        this.blurConfig.setLayout(new BoxLayout(this.blurConfig, 1));
        this.addCenterLabel("Blur Config", this.blurConfig);
        this.addLabeled(this.blurRadius, "Radius", this.blurConfig);
        return this.blurConfig;
    }

    public void setWaveletActive(boolean active) {
        if (active) {
            this.configHolder.remove(this.blurConfig);
            this.configHolder.add(this.waveletConfig);
        } else {
            this.configHolder.remove(this.waveletConfig);
            this.configHolder.add(this.blurConfig);
        }
        this.validate();
    }

    public void addWaveletName(String name) {
        this.waveletBox.addItem(name);
        this.waveletBox.validate();
    }

    private JTextArea createErrorComponent() {
        JTextArea comp = new JTextArea(1, 6);
        comp.setMaximumSize(comp.getPreferredSize());
        comp.setEditable(false);
        return comp;
    }

    public void reset() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DenoiseInfoPanel.this.images.setSelectedIndex(0);
                DenoiseInfoPanel.this.noiseLevel.setValue(20);
            }
        });
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.noiseLevel) {
            this.listener.noiseChange(this.getNoiseSigma());
        } else if (e.getSource() == this.blurRadius) {
            this.listener.noiseChange(this.getBlurRadius());
        } else if (e.getSource() == this.waveletLevel) {
            this.listener.waveletChange(this.waveletBox.getSelectedIndex(), this.getWaveletLevel());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.images) {
            this.listener.imageChange(this.images.getSelectedIndex());
        } else {
            this.listener.waveletChange(this.waveletBox.getSelectedIndex(), this.getWaveletLevel());
        }
    }

    public void setError(double algError, double algErrorEdge, double noiseError, double noiseErrorEdge) {
        this.algError.setText(String.format("%5.1f", algError));
        this.algErrorEdge.setText(String.format("%5.1f", algErrorEdge));
        this.noiseError.setText(String.format("%5.1f", noiseError));
        this.noiseErrorEdge.setText(String.format("%5.1f", noiseErrorEdge));
    }

    public int getWaveletLevel() {
        return ((Number)this.waveletLevel.getValue()).intValue();
    }

    public int getBlurRadius() {
        return ((Number)this.blurRadius.getValue()).intValue();
    }

    public float getNoiseSigma() {
        return ((Number)this.noiseLevel.getValue()).floatValue();
    }

    public static interface Listener {
        public void noiseChange(int var1);

        public void waveletChange(int var1, int var2);

        public void noiseChange(float var1);

        public void imageChange(int var1);
    }
}

