/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.gui.StandardAlgConfigPanel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SubpixelCalibControlPanel
extends StandardAlgConfigPanel
implements ItemListener,
ChangeListener {
    JCheckBox showPixel;
    JCheckBox showSubpixel;
    JSpinner selectZoom;
    Listener listener;
    boolean doShowPixel = true;
    boolean doShowSubpixel = true;
    double zoom = 1.0;

    public SubpixelCalibControlPanel(Listener listener) {
        this.listener = listener;
        this.selectZoom = new JSpinner(new SpinnerNumberModel(this.zoom, 1.0, 100.0, 1.0));
        this.selectZoom.addChangeListener(this);
        this.selectZoom.setMaximumSize(this.selectZoom.getPreferredSize());
        this.showPixel = new JCheckBox("Show Crude");
        this.showPixel.setSelected(this.doShowPixel);
        this.showPixel.addItemListener(this);
        this.showPixel.setMaximumSize(this.showPixel.getPreferredSize());
        this.showSubpixel = new JCheckBox("Show Refined");
        this.showSubpixel.setSelected(this.doShowSubpixel);
        this.showSubpixel.addItemListener(this);
        this.showSubpixel.setMaximumSize(this.showSubpixel.getPreferredSize());
        this.addLabeled(this.selectZoom, "Zoom:", this);
        this.addAlignLeft(this.showPixel, this);
        this.addAlignLeft(this.showSubpixel, this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.selectZoom) {
            this.zoom = ((Number)this.selectZoom.getValue()).doubleValue();
        }
        this.listener.updateGUI();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.showPixel) {
            this.doShowPixel = this.showPixel.isSelected();
        } else if (e.getSource() == this.showSubpixel) {
            this.doShowSubpixel = this.showSubpixel.isSelected();
        }
        this.listener.updateGUI();
    }

    public boolean isShowPixel() {
        return this.doShowPixel;
    }

    public boolean isShowSubpixel() {
        return this.doShowSubpixel;
    }

    public double getScale() {
        return this.zoom;
    }

    public static interface Listener {
        public void updateGUI();
    }
}

