/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.abst.fiducial.calib.CalibrationDetectorChessboard;
import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.geo.calibration.CalibrateMonoPlanar;
import boofcv.abst.geo.calibration.CalibrationDetector;
import boofcv.demonstrations.calibration.ParseMonoCalibrationConfig;
import boofcv.factory.calib.FactoryCalibrationTarget;
import boofcv.gui.VisualizeApp;
import boofcv.gui.calibration.MonoPlanarPanel;
import boofcv.io.MediaManager;
import boofcv.io.ProgressMonitorThread;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.GrayF32;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class CalibrateMonoPlanarGuiApp
extends JPanel
implements VisualizeApp {
    CalibrateMonoPlanar calibrator;
    MonoPlanarPanel gui = new MonoPlanarPanel();
    JPanel owner;
    List<String> images;
    MediaManager media = DefaultMediaManager.INSTANCE;

    public CalibrateMonoPlanarGuiApp() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 525));
        this.owner = this;
        this.add((Component)this.gui, "Center");
    }

    public void configure(CalibrationDetector detector, List<String> images, int numRadial, boolean includeTangential) {
        if (images.size() == 0) {
            throw new IllegalArgumentException("No images!");
        }
        Collections.sort(images);
        this.calibrator = new CalibrateMonoPlanar(detector);
        this.calibrator.configure(true, numRadial, includeTangential);
        this.images = images;
    }

    @Override
    public void loadConfigurationFile(String fileName) {
        ParseMonoCalibrationConfig parser = new ParseMonoCalibrationConfig(this.media);
        if (parser.parse(fileName)) {
            this.configure(parser.detector, parser.images, parser.numRadial, parser.includeTangential);
        } else {
            System.err.println("Configuration failed");
        }
    }

    public void process(String outputFileName) {
        this.calibrator.reset();
        final ProcessThread monitor = new ProcessThread();
        monitor.start();
        for (int i = 0; i < this.images.size(); ++i) {
            final File file = new File(this.images.get(i));
            final BufferedImage orig = this.media.openImage(this.images.get(i));
            if (orig != null) {
                GrayF32 input = ConvertBufferedImage.convertFrom(orig, (GrayF32)null);
                if (this.calibrator.addImage(input)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CalibrateMonoPlanarGuiApp.this.gui.addImage(file.getName(), orig);
                            CalibrateMonoPlanarGuiApp.this.gui.repaint();
                            monitor.setMessage(0, file.getName());
                        }
                    });
                    continue;
                }
                System.out.println("Failed to detect image.  " + file.getName());
                continue;
            }
            System.out.println("Failed to load " + this.images.get(i));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CalibrateMonoPlanarGuiApp.this.gui.setObservations(CalibrateMonoPlanarGuiApp.this.calibrator.getObservations());
            }
        });
        this.gui.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                monitor.setMessage(1, "Estimating Parameters");
            }
        });
        final IntrinsicParameters param = this.calibrator.process();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CalibrateMonoPlanarGuiApp.this.gui.setResults(CalibrateMonoPlanarGuiApp.this.calibrator.getErrors());
                CalibrateMonoPlanarGuiApp.this.gui.setCalibration(CalibrateMonoPlanarGuiApp.this.calibrator.getZhangParam());
            }
        });
        monitor.stopThread();
        if (outputFileName != null) {
            UtilIO.saveXML(param, outputFileName);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CalibrateMonoPlanarGuiApp.this.gui.setCorrection(param);
                CalibrateMonoPlanarGuiApp.this.gui.repaint();
            }
        });
        this.calibrator.printStatistics();
        System.out.println();
        System.out.println("--- Intrinsic Parameters ---");
        System.out.println();
        param.print();
    }

    @Override
    public void setMediaManager(MediaManager manager) {
        this.media = manager;
    }

    @Override
    public void loadInputData(String fileName) {
        new Thread(){

            @Override
            public void run() {
                CalibrateMonoPlanarGuiApp.this.process(null);
            }
        }.start();
    }

    @Override
    public boolean getHasProcessedImage() {
        return true;
    }

    public static void main(String[] args) {
        CalibrationDetectorChessboard detector = FactoryCalibrationTarget.detectorChessboard(new ConfigChessboard(7, 5, 30.0));
        String directory = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess");
        CalibrateMonoPlanarGuiApp app = new CalibrateMonoPlanarGuiApp();
        app.configure(detector, BoofMiscOps.directoryList(directory, "left"), 2, false);
        JFrame frame = new JFrame("Planar Calibration");
        frame.add((Component)app, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        app.process("intrinsic.xml");
    }

    public class ProcessThread
    extends ProgressMonitorThread {
        public ProcessThread() {
            super(new ProgressMonitor(CalibrateMonoPlanarGuiApp.this.owner, "Computing Calibration", "", 0, 2));
        }

        public void setMessage(final int state, final String message) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProcessThread.this.monitor.setProgress(state);
                    ProcessThread.this.monitor.setNote(message);
                }
            });
        }

        @Override
        public void doRun() {
        }
    }
}

