/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.binary;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.demonstrations.binary.SelectHistogramThresholdPanel;
import boofcv.factory.filter.binary.FactoryBinaryImageOps;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DemoBinaryImageLabelOpsApp<T extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements SelectHistogramThresholdPanel.Listener {
    Random rand = new Random(234234L);
    Class<T> imageType;
    T imageInput;
    GrayU8 imageBinary;
    GrayU8 imageOutput1;
    GrayU8 imageOutput2;
    GrayS32 imageLabeled;
    ImageGray selectedVisualize;
    FilterImageInterface<GrayU8, GrayU8> filter1;
    FilterImageInterface<GrayU8, GrayU8> filter2;
    ConnectRule connectRule;
    BufferedImage work;
    int[] colors;
    boolean processedImage = false;
    JComboBox imagesCombo;
    SelectHistogramThresholdPanel selectThresh;
    ImagePanel gui = new ImagePanel();

    public DemoBinaryImageLabelOpsApp(Class<T> imageType) {
        super(3);
        this.imageType = imageType;
        this.addAlgorithm(0, "Erode-4", FactoryBinaryImageOps.erode4());
        this.addAlgorithm(0, "Erode-8", FactoryBinaryImageOps.erode8());
        this.addAlgorithm(0, "Dilate-4", FactoryBinaryImageOps.dilate4());
        this.addAlgorithm(0, "Dilate-8", FactoryBinaryImageOps.dilate8());
        this.addAlgorithm(0, "Remove Noise", FactoryBinaryImageOps.removePointNoise());
        this.addAlgorithm(1, "Erode-4", FactoryBinaryImageOps.erode4());
        this.addAlgorithm(1, "Erode-8", FactoryBinaryImageOps.erode8());
        this.addAlgorithm(1, "Dilate-4", FactoryBinaryImageOps.dilate4());
        this.addAlgorithm(1, "Dilate-8", FactoryBinaryImageOps.dilate8());
        this.addAlgorithm(1, "Remove Noise", FactoryBinaryImageOps.removePointNoise());
        this.addAlgorithm(2, "Label-4", 4);
        this.addAlgorithm(2, "Label-8", 8);
        JPanel body = new JPanel();
        body.setLayout(new BorderLayout());
        body.add((Component)this.createControlPanel(), "North");
        body.add((Component)this.gui, "Center");
        this.imageInput = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.imageBinary = new GrayU8(1, 1);
        this.imageOutput1 = new GrayU8(1, 1);
        this.imageOutput2 = new GrayU8(1, 1);
        this.imageLabeled = new GrayS32(1, 1);
        this.selectedVisualize = this.imageLabeled;
        this.setMainGUI(body);
    }

    private JPanel createControlPanel() {
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 0));
        this.imagesCombo = new JComboBox();
        this.imagesCombo.addItem("Thresholded");
        this.imagesCombo.addItem("Filtered 1");
        this.imagesCombo.addItem("Filtered 2");
        this.imagesCombo.addItem("Labeled");
        this.imagesCombo.addActionListener(this);
        this.imagesCombo.setSelectedIndex(3);
        this.imagesCombo.setMaximumSize(this.imagesCombo.getPreferredSize());
        this.selectThresh = new SelectHistogramThresholdPanel(20, true);
        this.selectThresh.setListener(this);
        left.add(this.imagesCombo);
        left.add(this.selectThresh);
        left.add(Box.createHorizontalGlue());
        return left;
    }

    public void process(final BufferedImage image) {
        ((ImageGray)this.imageInput).reshape(image.getWidth(), image.getHeight());
        this.imageBinary.reshape(image.getWidth(), image.getHeight());
        this.imageOutput1.reshape(image.getWidth(), image.getHeight());
        this.imageOutput2.reshape(image.getWidth(), image.getHeight());
        this.imageLabeled.reshape(image.getWidth(), image.getHeight());
        ConvertBufferedImage.convertFromSingle(image, this.imageInput, this.imageType);
        final double threshold = GThresholdImageOps.computeOtsu(this.imageInput, 0, 255);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DemoBinaryImageLabelOpsApp.this.selectThresh.setThreshold((int)threshold);
                DemoBinaryImageLabelOpsApp.this.setInputImage(image);
                DemoBinaryImageLabelOpsApp.this.selectThresh.getHistogramPanel().update((ImageGray)DemoBinaryImageLabelOpsApp.this.imageInput);
                DemoBinaryImageLabelOpsApp.this.selectThresh.repaint();
            }
        });
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.filter1 = (FilterImageInterface)cookies[0];
        this.filter2 = (FilterImageInterface)cookies[1];
        this.connectRule = (Integer)cookies[2] == 4 ? ConnectRule.FOUR : ConnectRule.EIGHT;
        this.performWork();
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        switch (indexFamily) {
            case 0: {
                this.filter1 = (FilterImageInterface)cookie;
                break;
            }
            case 1: {
                this.filter2 = (FilterImageInterface)cookie;
                break;
            }
            case 2: {
                this.connectRule = (Integer)cookie == 4 ? ConnectRule.FOUR : ConnectRule.EIGHT;
            }
        }
        this.performWork();
    }

    private synchronized void performWork() {
        if (this.filter1 == null || this.filter2 == null) {
            return;
        }
        GThresholdImageOps.threshold(this.imageInput, this.imageBinary, this.selectThresh.getThreshold(), this.selectThresh.isDown());
        this.filter1.process(this.imageBinary, this.imageOutput1);
        this.filter2.process(this.imageOutput1, this.imageOutput2);
        List<Contour> found = BinaryImageOps.contour(this.imageOutput2, this.connectRule, this.imageLabeled);
        if (this.colors == null || this.colors.length <= found.size()) {
            this.colors = BinaryImageOps.selectRandomColors(found.size(), this.rand);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DemoBinaryImageLabelOpsApp.this.work == null || DemoBinaryImageLabelOpsApp.this.work.getWidth() != ((ImageGray)DemoBinaryImageLabelOpsApp.this.imageInput).width || DemoBinaryImageLabelOpsApp.this.work.getHeight() != ((ImageGray)DemoBinaryImageLabelOpsApp.this.imageInput).height) {
                    DemoBinaryImageLabelOpsApp.this.work = new BufferedImage(((ImageGray)DemoBinaryImageLabelOpsApp.this.imageInput).width, ((ImageGray)DemoBinaryImageLabelOpsApp.this.imageInput).height, 4);
                }
                DemoBinaryImageLabelOpsApp.this.renderVisualizeImage();
                DemoBinaryImageLabelOpsApp.this.gui.setBufferedImage(DemoBinaryImageLabelOpsApp.this.work);
                DemoBinaryImageLabelOpsApp.this.gui.setPreferredSize(new Dimension(((ImageGray)DemoBinaryImageLabelOpsApp.this.imageInput).width, ((ImageGray)DemoBinaryImageLabelOpsApp.this.imageInput).height));
                DemoBinaryImageLabelOpsApp.this.processedImage = true;
                DemoBinaryImageLabelOpsApp.this.gui.repaint();
            }
        });
    }

    private synchronized void renderVisualizeImage() {
        if (this.selectedVisualize instanceof GrayU8) {
            VisualizeBinaryData.renderBinary((GrayU8)this.selectedVisualize, false, this.work);
        } else {
            VisualizeBinaryData.renderLabeled((GrayS32)this.selectedVisualize, this.colors, this.work);
        }
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.imagesCombo) {
            int index = this.imagesCombo.getSelectedIndex();
            if (index == 0) {
                this.selectedVisualize = this.imageBinary;
            } else if (index == 1) {
                this.selectedVisualize = this.imageOutput1;
            } else if (index == 2) {
                this.selectedVisualize = this.imageOutput2;
            } else if (index == 3) {
                this.selectedVisualize = this.imageLabeled;
            }
            if (this.work != null) {
                this.renderVisualizeImage();
                this.gui.repaint();
            }
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void histogramThresholdChange() {
        this.performWork();
    }

    public static void main(String[] args) {
        DemoBinaryImageLabelOpsApp<GrayF32> app = new DemoBinaryImageLabelOpsApp<GrayF32>(GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("particles", UtilIO.pathExample("particles01.jpg")));
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Label Binary Blobs", true);
        System.out.println("Done");
    }
}

