/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.array;

public class LagrangeFormula {
    public static double process_F64(double sample, double[] x, double[] y, int i0, int i1) {
        double result = 0.0;
        for (int i = i0; i <= i1; ++i) {
            double numerator = 1.0;
            for (int j = i0; j <= i1; ++j) {
                if (i == j) continue;
                numerator *= sample - x[j];
            }
            double denominator = 1.0;
            double a = x[i];
            for (int j = i0; j <= i1; ++j) {
                if (i == j) continue;
                denominator *= a - x[j];
            }
            result += numerator / denominator * y[i];
        }
        return result;
    }

    public static float process_F32(float sample, float[] x, float[] y, int i0, int i1) {
        float result = 0.0f;
        for (int i = i0; i <= i1; ++i) {
            float numerator = 1.0f;
            for (int j = i0; j <= i1; ++j) {
                if (i == j) continue;
                numerator *= sample - x[j];
            }
            float denominator = 1.0f;
            float a = x[i];
            for (int j = i0; j <= i1; ++j) {
                if (i == j) continue;
                denominator *= a - x[j];
            }
            result += numerator / denominator * y[i];
        }
        return result;
    }
}

