/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.struct.geo.TrifocalTensor;
import georegression.struct.point.Point3D_F64;
import org.ejml.alg.dense.decomposition.svd.SafeSvd;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public class EnforceTrifocalGeometry {
    private SingularValueDecomposition<DenseMatrix64F> svdU;
    private SingularValueDecomposition<DenseMatrix64F> svdV;
    private DenseMatrix64F U = new DenseMatrix64F(27, 18);
    private DenseMatrix64F Up = new DenseMatrix64F(1, 1);
    private DenseMatrix64F xp = new DenseMatrix64F(1, 1);
    private DenseMatrix64F AU = new DenseMatrix64F(1, 1);
    private DenseMatrix64F vectorT = new DenseMatrix64F(27, 1);
    protected DenseMatrix64F E = new DenseMatrix64F(27, 18);

    public EnforceTrifocalGeometry() {
        this.svdU = DecompositionFactory.svd((int)10, (int)10, (boolean)true, (boolean)false, (boolean)true);
        this.svdV = DecompositionFactory.svd((int)10, (int)10, (boolean)false, (boolean)true, (boolean)false);
        this.svdV = new SafeSvd(this.svdV);
    }

    public void process(Point3D_F64 e2, Point3D_F64 e3, DenseMatrix64F A) {
        this.constructE(e2, e3);
        this.svdU.decompose((Matrix)this.E);
        this.svdU.getU((Matrix)this.U, false);
        SingularOps.descendingOrder((DenseMatrix64F)this.U, (boolean)false, (double[])this.svdU.getSingularValues(), (int)this.svdU.numberOfSingularValues(), null, (boolean)false);
        int rank = SingularOps.rank(this.svdU, (double)1.0E-13);
        this.Up.reshape(this.U.numRows, rank);
        CommonOps.extract((RealMatrix64F)this.U, (int)0, (int)this.U.numRows, (int)0, (int)this.Up.numCols, (RealMatrix64F)this.Up, (int)0, (int)0);
        this.AU.reshape(A.numRows, this.Up.numCols);
        CommonOps.mult((RowD1Matrix64F)A, (RowD1Matrix64F)this.Up, (RowD1Matrix64F)this.AU);
        this.svdV.decompose((Matrix)this.AU);
        this.xp.reshape(rank, 1);
        SingularOps.nullVector(this.svdV, (boolean)true, (DenseMatrix64F)this.xp);
        CommonOps.mult((RowD1Matrix64F)this.Up, (RowD1Matrix64F)this.xp, (RowD1Matrix64F)this.vectorT);
        if (this.vectorT.data[0] > 0.0) {
            CommonOps.changeSign((D1Matrix64F)this.vectorT);
        }
    }

    public void computeErrorVector(DenseMatrix64F A, DenseMatrix64F errors) {
        errors.reshape(A.numRows, 1);
        CommonOps.mult((RowD1Matrix64F)A, (RowD1Matrix64F)this.vectorT, (RowD1Matrix64F)errors);
    }

    public void extractSolution(TrifocalTensor tensor) {
        tensor.convertFrom(this.vectorT);
    }

    protected void constructE(Point3D_F64 e2, Point3D_F64 e3) {
        this.E.zero();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    int row = 9 * i + 3 * j + k;
                    int col1 = j * 3 + i;
                    int col2 = k * 3 + i + 9;
                    this.E.data[row * 18 + col1] = e3.getIndex(k);
                    this.E.data[row * 18 + col2] = -e2.getIndex(j);
                }
            }
        }
    }
}

