/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.triangulate;

import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.SingularOps;

public class TriangulateLinearDLT {
    SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)4, (int)4, (boolean)true, (boolean)true, (boolean)false);
    DenseMatrix64F v = new DenseMatrix64F(4, 1);
    DenseMatrix64F A = new DenseMatrix64F(4, 4);

    public void triangulate(List<Point2D_F64> observations, List<Se3_F64> worldToView, Point3D_F64 found) {
        if (observations.size() != worldToView.size()) {
            throw new IllegalArgumentException("Number of observations must match the number of motions");
        }
        int N = worldToView.size();
        this.A.reshape(2 * N, 4, false);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            index = this.addView(worldToView.get(i), observations.get(i), index);
        }
        if (!this.svd.decompose((Matrix)this.A)) {
            throw new RuntimeException("SVD failed!?!?");
        }
        SingularOps.nullVector(this.svd, (boolean)true, (DenseMatrix64F)this.v);
        double w = this.v.get(3);
        found.x = this.v.get(0) / w;
        found.y = this.v.get(1) / w;
        found.z = this.v.get(2) / w;
    }

    public void triangulate(Point2D_F64 a, Point2D_F64 b, Se3_F64 fromAtoB, Point3D_F64 foundInA) {
        this.A.reshape(4, 4, false);
        int index = this.addView(fromAtoB, b, 0);
        this.A.data[index++] = -1.0;
        this.A.data[index++] = 0.0;
        this.A.data[index++] = a.x;
        this.A.data[index++] = 0.0;
        this.A.data[index++] = 0.0;
        this.A.data[index++] = -1.0;
        this.A.data[index++] = a.y;
        this.A.data[index] = 0.0;
        if (!this.svd.decompose((Matrix)this.A)) {
            throw new RuntimeException("SVD failed!?!?");
        }
        SingularOps.nullVector(this.svd, (boolean)true, (DenseMatrix64F)this.v);
        double w = this.v.get(3);
        foundInA.x = this.v.get(0) / w;
        foundInA.y = this.v.get(1) / w;
        foundInA.z = this.v.get(2) / w;
    }

    private int addView(Se3_F64 motion, Point2D_F64 a, int index) {
        DenseMatrix64F R = motion.getR();
        Vector3D_F64 T = motion.getT();
        double r11 = R.data[0];
        double r12 = R.data[1];
        double r13 = R.data[2];
        double r21 = R.data[3];
        double r22 = R.data[4];
        double r23 = R.data[5];
        double r31 = R.data[6];
        double r32 = R.data[7];
        double r33 = R.data[8];
        this.A.data[index++] = a.x * r31 - r11;
        this.A.data[index++] = a.x * r32 - r12;
        this.A.data[index++] = a.x * r33 - r13;
        this.A.data[index++] = a.x * T.z - T.x;
        this.A.data[index++] = a.y * r31 - r21;
        this.A.data[index++] = a.y * r32 - r22;
        this.A.data[index++] = a.y * r33 - r23;
        this.A.data[index++] = a.y * T.z - T.y;
        return index;
    }
}

