/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.flow;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public abstract class HornSchunck<T extends ImageBase, D extends ImageBase> {
    protected float alpha2;
    protected int numIterations;
    protected ImageFlow averageFlow = new ImageFlow(1, 1);
    protected boolean resetOutput = true;
    protected D derivX;
    protected D derivY;
    protected D derivT;

    public HornSchunck(float alpha, int numIterations, ImageType<D> derivType) {
        this.alpha2 = alpha * alpha;
        this.numIterations = numIterations;
        this.derivX = derivType.createImage(1, 1);
        this.derivY = derivType.createImage(1, 1);
        this.derivT = derivType.createImage(1, 1);
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public void process(T image1, T image2, ImageFlow output) {
        InputSanityCheck.checkSameShape(image1, image2);
        ((ImageBase)this.derivX).reshape(((ImageBase)image1).width, ((ImageBase)image1).height);
        ((ImageBase)this.derivY).reshape(((ImageBase)image1).width, ((ImageBase)image1).height);
        ((ImageBase)this.derivT).reshape(((ImageBase)image1).width, ((ImageBase)image1).height);
        this.averageFlow.reshape(output.width, output.height);
        if (this.resetOutput) {
            output.fillZero();
        }
        this.computeDerivX(image1, image2, this.derivX);
        this.computeDerivY(image1, image2, this.derivY);
        this.computeDerivT(image1, image2, this.derivT);
        this.findFlow(this.derivX, this.derivY, this.derivT, output);
    }

    protected abstract void computeDerivX(T var1, T var2, D var3);

    protected abstract void computeDerivY(T var1, T var2, D var3);

    protected abstract void computeDerivT(T var1, T var2, D var3);

    protected abstract void findFlow(D var1, D var2, D var3, ImageFlow var4);

    protected static void innerAverageFlow(ImageFlow flow, ImageFlow averageFlow) {
        int endX = flow.width - 1;
        int endY = flow.height - 1;
        for (int y = 1; y < endY; ++y) {
            int index = flow.width * y + 1;
            int x = 1;
            while (x < endX) {
                ImageFlow.D average = averageFlow.data[index];
                ImageFlow.D f0 = flow.data[index - 1];
                ImageFlow.D f1 = flow.data[index + 1];
                ImageFlow.D f2 = flow.data[index - flow.width];
                ImageFlow.D f3 = flow.data[index + flow.width];
                ImageFlow.D f4 = flow.data[index - 1 - flow.width];
                ImageFlow.D f5 = flow.data[index + 1 - flow.width];
                ImageFlow.D f6 = flow.data[index - 1 + flow.width];
                ImageFlow.D f7 = flow.data[index + 1 + flow.width];
                average.x = 0.1666667f * (f0.x + f1.x + f2.x + f3.x) + 0.08333333f * (f4.x + f5.x + f6.x + f7.x);
                average.y = 0.1666667f * (f0.y + f1.y + f2.y + f3.y) + 0.08333333f * (f4.y + f5.y + f6.y + f7.y);
                ++x;
                ++index;
            }
        }
    }

    protected static void borderAverageFlow(ImageFlow flow, ImageFlow averageFlow) {
        for (int y = 0; y < flow.height; ++y) {
            HornSchunck.computeBorder(flow, averageFlow, 0, y);
            HornSchunck.computeBorder(flow, averageFlow, flow.width - 1, y);
        }
        for (int x = 1; x < flow.width - 1; ++x) {
            HornSchunck.computeBorder(flow, averageFlow, x, 0);
            HornSchunck.computeBorder(flow, averageFlow, x, flow.height - 1);
        }
    }

    protected static void computeBorder(ImageFlow flow, ImageFlow averageFlow, int x, int y) {
        ImageFlow.D average = averageFlow.get(x, y);
        ImageFlow.D f0 = HornSchunck.getExtend(flow, x - 1, y);
        ImageFlow.D f1 = HornSchunck.getExtend(flow, x + 1, y);
        ImageFlow.D f2 = HornSchunck.getExtend(flow, x, y - 1);
        ImageFlow.D f3 = HornSchunck.getExtend(flow, x, y + 1);
        ImageFlow.D f4 = HornSchunck.getExtend(flow, x - 1, y - 1);
        ImageFlow.D f5 = HornSchunck.getExtend(flow, x + 1, y - 1);
        ImageFlow.D f6 = HornSchunck.getExtend(flow, x - 1, y + 1);
        ImageFlow.D f7 = HornSchunck.getExtend(flow, x + 1, y + 1);
        average.x = 0.1666667f * (f0.x + f1.x + f2.x + f3.x) + 0.08333333f * (f4.x + f5.x + f6.x + f7.x);
        average.y = 0.1666667f * (f0.y + f1.y + f2.y + f3.y) + 0.08333333f * (f4.y + f5.y + f6.y + f7.y);
    }

    protected static ImageFlow.D getExtend(ImageFlow flow, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= flow.width) {
            x = flow.width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= flow.height) {
            y = flow.height - 1;
        }
        return flow.unsafe_get(x, y);
    }
}

