/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareEdge;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import georegression.struct.line.LineSegment2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.RecycleManager;

public class SquaresIntoClusters {
    protected FastQueue<SquareNode> nodes = new FastQueue(SquareNode.class, true);
    protected FastQueue<List<SquareNode>> clusters = new FastQueue(ArrayList.class, true);
    protected List<SquareNode> open = new ArrayList<SquareNode>();
    protected RecycleManager<SquareEdge> edges = new RecycleManager(SquareEdge.class);
    protected LineSegment2D_F64 lineA = new LineSegment2D_F64();
    protected LineSegment2D_F64 lineB = new LineSegment2D_F64();

    protected void recycleData() {
        int j;
        SquareNode n;
        int i;
        for (i = 0; i < this.nodes.size(); ++i) {
            n = (SquareNode)this.nodes.get(i);
            for (j = 0; j < n.edges.length; ++j) {
                if (n.edges[j] == null) continue;
                this.detachEdge(n.edges[j]);
            }
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            n = (SquareNode)this.nodes.get(i);
            for (j = 0; j < n.edges.length; ++j) {
                if (n.edges[j] == null) continue;
                throw new RuntimeException("BUG!");
            }
        }
        this.nodes.reset();
        for (i = 0; i < this.clusters.size; ++i) {
            ((List)this.clusters.get(i)).clear();
        }
        this.clusters.reset();
    }

    protected void findClusters() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            SquareNode n = (SquareNode)this.nodes.get(i);
            if (n.graph >= 0) continue;
            n.graph = this.clusters.size();
            List graph = (List)this.clusters.grow();
            graph.add(n);
            this.addToCluster(n, graph);
        }
    }

    void addToCluster(SquareNode seed, List<SquareNode> graph) {
        this.open.clear();
        this.open.add(seed);
        while (!this.open.isEmpty()) {
            SquareNode n = this.open.remove(this.open.size() - 1);
            for (int i = 0; i < n.corners.size(); ++i) {
                SquareNode other;
                SquareEdge edge = n.edges[i];
                if (edge == null) continue;
                if (edge.a == n) {
                    other = edge.b;
                } else if (edge.b == n) {
                    other = edge.a;
                } else {
                    throw new RuntimeException("BUG!");
                }
                if (other.graph == -2) {
                    other.graph = n.graph;
                    graph.add(other);
                    this.open.add(other);
                    continue;
                }
                if (other.graph == n.graph) continue;
                throw new RuntimeException("BUG! " + other.graph + " " + n.graph);
            }
        }
    }

    void detachEdge(SquareEdge edge) {
        edge.a.edges[edge.sideA] = null;
        edge.b.edges[edge.sideB] = null;
        edge.distance = 0.0;
        this.edges.recycleInstance((Object)edge);
    }

    void connect(SquareNode a, int indexA, SquareNode b, int indexB, double distance) {
        SquareEdge edge = (SquareEdge)this.edges.requestInstance();
        edge.reset();
        edge.a = a;
        edge.sideA = indexA;
        edge.b = b;
        edge.sideB = indexB;
        edge.distance = distance;
        a.edges[indexA] = edge;
        b.edges[indexB] = edge;
    }
}

