/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.dense.impl;

import boofcv.alg.feature.dense.DescribeDenseHogAlg;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;

public class DescribeDenseHogAlg_PLU8
extends DescribeDenseHogAlg<Planar<GrayU8>, Planar<GrayS16>> {
    int numBands;

    public DescribeDenseHogAlg_PLU8(int orientationBins, int widthCell, int widthBlock, int stepBlock, int numBands) {
        super(orientationBins, widthCell, widthBlock, stepBlock, ImageType.pl(numBands, GrayU8.class));
        this.numBands = numBands;
    }

    @Override
    public void computeDerivative(int pixelIndex) {
        float maxDX = 0.0f;
        float maxDY = 0.0f;
        float maxNorm = 0.0f;
        for (int i = 0; i < this.numBands; ++i) {
            float dx = ((GrayS16[])((Planar)this.derivX).bands)[i].data[pixelIndex];
            float dy = ((GrayS16[])((Planar)this.derivY).bands)[i].data[pixelIndex];
            float n = dx * dx + dy * dy;
            if (!(n > maxNorm)) continue;
            maxNorm = n;
            maxDX = dx;
            maxDY = dy;
        }
        this.pixelDX = maxDX;
        this.pixelDY = maxDY;
    }
}

