/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.radtan;

import boofcv.alg.distort.radtan.RadialTangential_F32;
import boofcv.struct.distort.PointTransform_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.struct.GeoTuple2D_F32;
import georegression.struct.point.Point2D_F32;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class RemoveRadialPtoN_F32
implements PointTransform_F32 {
    protected float cx;
    protected float cy;
    protected float fx;
    protected float fy;
    protected float skew;
    protected RadialTangential_F32 params;
    protected float sum;
    protected float tx;
    protected float ty;
    protected DenseMatrix64F K_inv = new DenseMatrix64F(3, 3);
    private float tol = 1.0E-5f;

    public RemoveRadialPtoN_F32() {
    }

    public RemoveRadialPtoN_F32(float tol) {
        this.tol = tol;
    }

    public void setTolerance(float tol) {
        this.tol = tol;
    }

    public RemoveRadialPtoN_F32 setK(double fx, double fy, double skew, double cx, double cy) {
        this.fx = (float)fx;
        this.fy = (float)fy;
        this.skew = (float)skew;
        this.cx = (float)cx;
        this.cy = (float)cy;
        this.K_inv.set(0, 0, fx);
        this.K_inv.set(1, 1, fy);
        this.K_inv.set(0, 1, skew);
        this.K_inv.set(0, 2, cx);
        this.K_inv.set(1, 2, cy);
        this.K_inv.set(2, 2, 1.0);
        CommonOps.invert((DenseMatrix64F)this.K_inv);
        return this;
    }

    public RemoveRadialPtoN_F32 setDistortion(double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F32().set(radial, t1, t2);
        return this;
    }

    @Override
    public void compute(float x, float y, Point2D_F32 out) {
        out.x = x;
        out.y = y;
        float[] radial = this.params.radial;
        float t1 = this.params.t1;
        float t2 = this.params.t2;
        GeometryMath_F32.mult((DenseMatrix64F)this.K_inv, (GeoTuple2D_F32)out, (GeoTuple2D_F32)out);
        float origX = x = out.x;
        float origY = y = out.y;
        float prevX = x;
        float prevY = y;
        for (int iter = 0; iter < 20; ++iter) {
            float r2;
            float ri2 = r2 = x * x + y * y;
            this.sum = 0.0f;
            for (int i = 0; i < radial.length; ++i) {
                this.sum += radial[i] * ri2;
                ri2 *= r2;
            }
            this.tx = 2.0f * t1 * x * y + t2 * (r2 + 2.0f * x * x);
            this.ty = t1 * (r2 + 2.0f * y * y) + 2.0f * t2 * x * y;
            x = (origX - this.tx) / (1.0f + this.sum);
            y = (origY - this.ty) / (1.0f + this.sum);
            if (Math.abs(prevX - x) <= this.tol && Math.abs(prevY - y) <= this.tol) break;
            prevX = x;
            prevY = y;
        }
        out.set(x, y);
    }
}

