/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.orientation;

import boofcv.abst.feature.orientation.OrientationGradient;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageGray;

public class OrientationGradientToImage<T extends ImageGray, D extends ImageGray>
implements OrientationImage<T> {
    ImageGradient<T, D> gradient;
    OrientationGradient<D> alg;
    D derivX;
    D derivY;
    Class<T> inputType;

    public OrientationGradientToImage(OrientationGradient<D> alg, ImageGradient<T, D> gradient, Class<T> inputType, Class<D> gradientType) {
        this.alg = alg;
        this.gradient = gradient;
        this.inputType = inputType;
        this.derivX = GeneralizedImageOps.createSingleBand(gradientType, 1, 1);
        this.derivY = GeneralizedImageOps.createSingleBand(gradientType, 1, 1);
    }

    @Override
    public void setImage(T image) {
        ((ImageGray)this.derivX).reshape(((ImageGray)image).width, ((ImageGray)image).height);
        ((ImageGray)this.derivY).reshape(((ImageGray)image).width, ((ImageGray)image).height);
        this.gradient.process(image, this.derivX, this.derivY);
        this.alg.setImage(this.derivX, this.derivY);
    }

    @Override
    public Class<T> getImageType() {
        return this.inputType;
    }

    @Override
    public void setObjectRadius(double radius) {
        this.alg.setObjectRadius(radius);
    }

    @Override
    public double compute(double c_x, double c_y) {
        return this.alg.compute(c_x, c_y);
    }
}

