/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.util;

import java.io.Serializable;

public abstract class Range
implements Cloneable {
    public abstract boolean isEmpty();

    public abstract boolean isStartIncluded();

    public abstract boolean isEndIncluded();

    public boolean isMinIncluded() {
        return !this.isInverted() ? this.isStartIncluded() : this.isEndIncluded();
    }

    public boolean isMaxIncluded() {
        return !this.isInverted() ? this.isEndIncluded() : this.isStartIncluded();
    }

    public boolean contains(double v) {
        if (!this.isInverted()) {
            return (this.getStart() < v || this.getStart() == v && this.isStartIncluded()) && (v < this.getEnd() || v == this.getEnd() && this.isEndIncluded());
        }
        return (this.getEnd() < v || this.getEnd() == v && this.isEndIncluded()) && (v < this.getStart() || v == this.getStart() && this.isStartIncluded());
    }

    public abstract double getStart();

    public abstract double getEnd();

    public abstract double getMin();

    public abstract double getMax();

    public abstract double getSpan();

    public abstract boolean isInverted();

    public abstract Range intersect(Range var1);

    public abstract Range union(Range var1);

    public abstract Range invert();

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Range copy() {
        try {
            return (Range)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }

    public static class Long
    extends Range
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final long start;
        public final long end;
        public final boolean empty;

        public Long() {
            this.start = 0L;
            this.end = 0L;
            this.empty = true;
        }

        public Long(long start, long end) {
            this.start = start;
            this.end = end;
            this.empty = false;
        }

        public Long(Range range) {
            if (!range.isInverted()) {
                long start = (long)Math.ceil(range.getStart());
                long end = (long)Math.floor(range.getEnd());
                if ((double)start == range.getStart() && !range.isStartIncluded()) {
                    ++start;
                }
                if ((double)end == range.getEnd() && !range.isEndIncluded()) {
                    --end;
                }
                if (start > end) {
                    this.empty = true;
                    this.start = 0L;
                    this.end = 0L;
                } else {
                    this.empty = false;
                    this.start = start;
                    this.end = end;
                }
            } else {
                long start = (long)Math.floor(range.getStart());
                long end = (long)Math.ceil(range.getEnd());
                if ((double)start == range.getStart() && !range.isStartIncluded()) {
                    --start;
                }
                if ((double)end == range.getEnd() && !range.isEndIncluded()) {
                    ++end;
                }
                if (start < end) {
                    this.empty = true;
                    this.start = 0L;
                    this.end = 0L;
                } else {
                    this.empty = false;
                    this.start = start;
                    this.end = end;
                }
            }
        }

        @Override
        public boolean isEmpty() {
            return this.empty;
        }

        @Override
        public boolean isStartIncluded() {
            return !this.empty;
        }

        @Override
        public boolean isEndIncluded() {
            return !this.empty;
        }

        @Override
        public double getStart() {
            return this.start;
        }

        @Override
        public double getEnd() {
            return this.end;
        }

        @Override
        public double getMin() {
            return Math.min(this.start, this.end);
        }

        @Override
        public double getMax() {
            return Math.max(this.start, this.end);
        }

        @Override
        public double getSpan() {
            return Math.abs(this.end - this.start);
        }

        @Override
        public boolean isInverted() {
            return this.start > this.end;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Long) {
                Long p2d = (Long)obj;
                if (this.isEmpty() && p2d.isEmpty()) {
                    return true;
                }
                return this.start == p2d.start && this.end == p2d.end && this.empty == p2d.empty;
            }
            return false;
        }

        public int hashCode() {
            long bits = this.start;
            return (int)(bits ^= this.end * 31L) ^ (int)(bits >> 32);
        }

        public String toString() {
            return "Range.Long[" + this.start + ", " + this.end + "]";
        }

        @Override
        public Long invert() {
            return new Long(this.end, this.start);
        }

        @Override
        public Range intersect(Range range) {
            long max;
            long min;
            long lmax;
            long lmin;
            Long lrange;
            if (range.isEmpty()) {
                return new Long();
            }
            Long longVal = lrange = range instanceof Long ? (Long)range : new Long(range);
            if (!lrange.isInverted()) {
                lmin = lrange.start;
                lmax = lrange.end;
            } else {
                lmin = lrange.end;
                lmax = lrange.start;
            }
            if (!this.isInverted()) {
                min = Math.max(this.start, lmin);
                max = Math.min(this.end, lmax);
            } else {
                min = Math.max(this.end, lmin);
                max = Math.min(this.start, lmax);
            }
            if (min > max) {
                return new Long();
            }
            if (!this.isInverted()) {
                return new Long(min, max);
            }
            return new Long(max, min);
        }

        @Override
        public Range union(Range range) {
            long max;
            long min;
            long lmax;
            long lmin;
            Long lrange;
            if (this.isEmpty()) {
                return range;
            }
            if (range.isEmpty()) {
                return this;
            }
            Long longVal = lrange = range instanceof Long ? (Long)range : new Long(range);
            if (!lrange.isInverted()) {
                lmin = lrange.start;
                lmax = lrange.end;
            } else {
                lmin = lrange.end;
                lmax = lrange.start;
            }
            if (!this.isInverted()) {
                min = Math.min(this.start, lmin);
                max = Math.max(this.end, lmax);
            } else {
                min = Math.min(this.end, lmin);
                max = Math.max(this.start, lmax);
            }
            if (min > max) {
                return new Long();
            }
            if (!this.isInverted()) {
                return new Long(min, max);
            }
            return new Long(max, min);
        }
    }

    public static class Double
    extends Range
    implements Serializable {
        private static final long serialVersionUID = 2L;
        public final double start;
        public final double end;
        public final boolean startIncl;
        public final boolean endIncl;
        public final boolean empty;

        public Double() {
            this(java.lang.Double.NaN, false, java.lang.Double.NaN, false);
        }

        public Double(double start, double end) {
            this(start, true, end, true);
        }

        public Double(double start, boolean startIncl, double end, boolean endIncl) {
            if (java.lang.Double.isNaN(start) || java.lang.Double.isNaN(end) || start == end && (!startIncl || !endIncl)) {
                this.empty = true;
                this.startIncl = false;
                this.endIncl = false;
                this.start = java.lang.Double.NaN;
                this.end = java.lang.Double.NaN;
            } else {
                this.empty = false;
                this.startIncl = startIncl;
                this.endIncl = endIncl;
                this.start = start;
                this.end = end;
            }
        }

        public Double(Range range) {
            this(range.getStart(), range.isStartIncluded(), range.getEnd(), range.isEndIncluded());
        }

        @Override
        public double getStart() {
            return this.start;
        }

        @Override
        public double getEnd() {
            return this.end;
        }

        @Override
        public boolean isStartIncluded() {
            return this.startIncl;
        }

        @Override
        public boolean isEndIncluded() {
            return this.endIncl;
        }

        @Override
        public double getMin() {
            return Math.min(this.start, this.end);
        }

        @Override
        public double getMax() {
            return Math.max(this.start, this.end);
        }

        @Override
        public double getSpan() {
            return Math.abs(this.end - this.start);
        }

        @Override
        public boolean isInverted() {
            return this.start > this.end;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Double) {
                Double p2d = (Double)obj;
                if (this.isEmpty() && p2d.isEmpty()) {
                    return true;
                }
                return this.start == p2d.start && this.startIncl == p2d.startIncl && this.end == p2d.end && this.endIncl == p2d.endIncl;
            }
            return false;
        }

        public int hashCode() {
            long bits = java.lang.Double.doubleToLongBits(this.start);
            return (int)(bits ^= java.lang.Double.doubleToLongBits(this.end) * 31L) ^ (int)(bits >> 32);
        }

        public String toString() {
            return "Range.Double" + (this.startIncl ? "[" : "(") + this.start + ", " + this.end + (this.endIncl ? "]" : ")");
        }

        @Override
        public Double invert() {
            return new Double(this.end, this.endIncl, this.start, this.startIncl);
        }

        @Override
        public Range intersect(Range range) {
            boolean maxincl;
            double max;
            boolean minincl;
            double min;
            if (range.isEmpty()) {
                return new Double();
            }
            if (this.getMin() == range.getMin()) {
                min = this.getMin();
                minincl = this.isMinIncluded() && range.isMinIncluded();
            } else if (this.getMin() > range.getMin()) {
                min = this.getMin();
                minincl = this.isMinIncluded();
            } else {
                min = range.getMin();
                minincl = range.isMinIncluded();
            }
            if (this.getMax() == range.getMax()) {
                max = this.getMax();
                maxincl = this.isMaxIncluded() && range.isMaxIncluded();
            } else if (this.getMax() < range.getMax()) {
                max = this.getMax();
                maxincl = this.isMaxIncluded();
            } else {
                max = range.getMax();
                maxincl = range.isMaxIncluded();
            }
            if (min > max) {
                return new Double();
            }
            if (!(min != max || minincl && maxincl)) {
                return new Double();
            }
            if (!this.isInverted()) {
                return new Double(min, minincl, max, maxincl);
            }
            return new Double(max, maxincl, min, minincl);
        }

        @Override
        public Range union(Range range) {
            boolean maxincl;
            double max;
            boolean minincl;
            double min;
            if (this.isEmpty()) {
                return range;
            }
            if (range.isEmpty()) {
                return this;
            }
            if (this.getMin() == range.getMin()) {
                min = this.getMin();
                minincl = this.isMinIncluded() || range.isMinIncluded();
            } else if (this.getMin() < range.getMin()) {
                min = this.getMin();
                minincl = this.isMinIncluded();
            } else {
                min = range.getMin();
                minincl = range.isMinIncluded();
            }
            if (this.getMax() == range.getMax()) {
                max = this.getMax();
                maxincl = this.isMaxIncluded() || range.isMaxIncluded();
            } else if (this.getMax() > range.getMax()) {
                max = this.getMax();
                maxincl = this.isMaxIncluded();
            } else {
                max = range.getMax();
                maxincl = range.isMaxIncluded();
            }
            if (min > max) {
                return new Double();
            }
            if (!(min != max || minincl && maxincl)) {
                return new Double();
            }
            if (!this.isInverted()) {
                return new Double(min, minincl, max, maxincl);
            }
            return new Double(max, maxincl, min, minincl);
        }

        @Override
        public boolean isEmpty() {
            return this.empty;
        }
    }
}

