/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.transform.PaperTransform;

public class RotatablePaperTransform
extends PaperTransform {
    private final double theta;

    public RotatablePaperTransform(double xoff, double yoff, double scale, double theta) {
        super(xoff, yoff, scale);
        this.theta = theta;
    }

    public RotatablePaperTransform(double xoff, double yoff, double scale) {
        this(xoff, yoff, scale, 0.0);
    }

    public RotatablePaperTransform(Point2D p, double scale) {
        this(p.getX(), p.getY(), scale, 0.0);
    }

    @Override
    public RotatablePaperTransform clone() {
        return (RotatablePaperTransform)super.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RotatablePaperTransform b = (RotatablePaperTransform)obj;
        return super.equals(b) && this.theta == b.theta;
    }

    @Override
    public double getXPtoD(double xp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getYPtoD(double yp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getXDtoP(double xd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getYDtoP(double yd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Point2D getPtoD(Point2D p) {
        return this.getTransform().transform(p, null);
    }

    @Override
    public Point2D getDtoP(Point2D d) {
        try {
            return this.getTransform().inverseTransform(d, null);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    @Override
    public Shape getPtoD(Rectangle2D rect) {
        return this.getTransform().createTransformedShape(rect);
    }

    @Override
    public AffineTransform getTransform() {
        AffineTransform af = super.getTransform();
        if (this.theta != 0.0) {
            af.rotate(this.theta);
        }
        return af;
    }

    @Override
    public String toString() {
        return super.toString() + " theta" + this.theta;
    }
}

