/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.property;

import java.awt.geom.Point2D;
import org.jplot2d.env.PropertyInfo;
import org.jplot2d.swing.proptable.property.MainProperty;
import org.jplot2d.swing.proptable.property.Property;
import org.jplot2d.swing.proptable.property.PropertyDescriptorAdapter;
import org.jplot2d.swing.proptable.property.SubProperty;

public class Point2DProperty
extends PropertyDescriptorAdapter<Point2D> {
    private Property<?>[] subProperties;
    private Double _x;
    private Double _y;

    public Point2DProperty(PropertyInfo descriptor) {
        super(descriptor);
        this.initSubProperties();
    }

    @Override
    public Property<?>[] getSubProperties() {
        return this.subProperties;
    }

    @Override
    public void readFromObject(Object object) {
        super.readFromObject(object);
        if (this.getValue() != null) {
            this._x = ((Point2D)this.getValue()).getX();
            this._y = ((Point2D)this.getValue()).getY();
        }
    }

    private void updateValue() {
        if (this._x != null && this._y != null) {
            this.setValue(new Point2D.Double(this._x, this._y));
        }
        if (this._x == null && this._y == null) {
            this.setValue(null);
        }
    }

    private void initSubProperties() {
        this.subProperties = new Property[2];
        this.subProperties[0] = new SubProperty<Double>((MainProperty)this){

            @Override
            public String getName() {
                return "x";
            }

            @Override
            public Class<Double> getType() {
                return Double.class;
            }

            @Override
            public Double getValue() {
                return Point2DProperty.this._x;
            }

            @Override
            public void setValue(Double x) {
                Point2DProperty.this._x = x;
                Point2DProperty.this.updateValue();
            }
        };
        this.subProperties[1] = new SubProperty<Double>((MainProperty)this){

            @Override
            public String getName() {
                return "y";
            }

            @Override
            public Class<Double> getType() {
                return Double.class;
            }

            @Override
            public Double getValue() {
                return Point2DProperty.this._y;
            }

            @Override
            public void setValue(Double y) {
                Point2DProperty.this._y = y;
                Point2DProperty.this.updateValue();
            }
        };
    }
}

