/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.property;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jplot2d.swing.proptable.property.Property;

public abstract class MainProperty<T>
implements Property<T> {
    private T value;
    private transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        T oldValue = this.value;
        this.value = value;
        if (!(value == oldValue || value != null && value.equals(oldValue))) {
            this.firePropertyChange(oldValue, this.getValue());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
        Property<?>[] subProperties = this.getSubProperties();
        if (subProperties != null) {
            for (Property<?> property : subProperties) {
                if (!(property instanceof MainProperty)) continue;
                ((MainProperty)property).addPropertyChangeListener(listener);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
        Property<?>[] subProperties = this.getSubProperties();
        if (subProperties != null) {
            for (Property<?> property : subProperties) {
                if (!(property instanceof MainProperty)) continue;
                ((MainProperty)property).removePropertyChangeListener(listener);
            }
        }
    }

    protected void firePropertyChange(Object oldValue, Object newValue) {
        this.listeners.firePropertyChange("value", oldValue, newValue);
    }

    @Override
    public Property<?>[] getSubProperties() {
        return null;
    }

    public abstract void readFromObject(Object var1);

    public abstract void writeToObject(Object var1) throws Throwable;

    @Override
    public Object[] getAvailableValues() {
        return null;
    }

    public String toString() {
        return "MainProperty " + this.getName();
    }
}

