/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.property;

import org.jplot2d.env.PropertyInfo;
import org.jplot2d.swing.proptable.property.MainProperty;
import org.jplot2d.swing.proptable.property.Property;
import org.jplot2d.swing.proptable.property.PropertyDescriptorAdapter;
import org.jplot2d.swing.proptable.property.SubProperty;
import org.jplot2d.util.Insets2D;

public class Insets2DProperty
extends PropertyDescriptorAdapter<Insets2D> {
    private Property<?>[] subProperties;
    private Double _top;
    private Double _left;
    private Double _bottom;
    private Double _right;

    public Insets2DProperty(PropertyInfo descriptor) {
        super(descriptor);
        this.initSubProperties();
    }

    @Override
    public Property<?>[] getSubProperties() {
        return this.subProperties;
    }

    @Override
    public void readFromObject(Object object) {
        super.readFromObject(object);
        if (this.getValue() != null) {
            this._top = ((Insets2D)this.getValue()).getTop();
            this._left = ((Insets2D)this.getValue()).getLeft();
            this._bottom = ((Insets2D)this.getValue()).getBottom();
            this._right = ((Insets2D)this.getValue()).getRight();
        }
    }

    private void updateValue() {
        if (this._top != null && this._left != null & this._bottom != null && this._right != null) {
            this.setValue(new Insets2D.Double(this._top, this._left, this._bottom, this._right));
        }
        if (this._top == null && this._left == null & this._bottom == null && this._right == null) {
            this.setValue(null);
        }
    }

    private void initSubProperties() {
        this.subProperties = new Property[4];
        this.subProperties[0] = new SubProperty<Double>((MainProperty)this){

            @Override
            public String getName() {
                return "top";
            }

            @Override
            public Class<Double> getType() {
                return Double.class;
            }

            @Override
            public Double getValue() {
                return Insets2DProperty.this._top;
            }

            @Override
            public void setValue(Double top) {
                Insets2DProperty.this._top = top;
                Insets2DProperty.this.updateValue();
            }
        };
        this.subProperties[1] = new SubProperty<Double>((MainProperty)this){

            @Override
            public String getName() {
                return "left";
            }

            @Override
            public Class<Double> getType() {
                return Double.class;
            }

            @Override
            public Double getValue() {
                return Insets2DProperty.this._left;
            }

            @Override
            public void setValue(Double left) {
                Insets2DProperty.this._left = left;
                Insets2DProperty.this.updateValue();
            }
        };
        this.subProperties[2] = new SubProperty<Double>((MainProperty)this){

            @Override
            public String getName() {
                return "bottom";
            }

            @Override
            public Class<Double> getType() {
                return Double.class;
            }

            @Override
            public Double getValue() {
                return Insets2DProperty.this._bottom;
            }

            @Override
            public void setValue(Double bottom) {
                Insets2DProperty.this._bottom = bottom;
                Insets2DProperty.this.updateValue();
            }
        };
        this.subProperties[3] = new SubProperty<Double>((MainProperty)this){

            @Override
            public String getName() {
                return "right";
            }

            @Override
            public Class<Double> getType() {
                return Double.class;
            }

            @Override
            public Double getValue() {
                return Insets2DProperty.this._right;
            }

            @Override
            public void setValue(Double right) {
                Insets2DProperty.this._right = right;
                Insets2DProperty.this.updateValue();
            }
        };
    }
}

