/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.editor;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;
import org.jplot2d.swing.proptable.editor.BooleanPropertyEditor;
import org.jplot2d.swing.proptable.editor.ColorPropertyEditor;
import org.jplot2d.swing.proptable.editor.ComboBoxPropertyEditor;
import org.jplot2d.swing.proptable.editor.DoubleArrayEditor;
import org.jplot2d.swing.proptable.editor.DoubleEditor;
import org.jplot2d.swing.proptable.editor.EnumPropertyEditor;
import org.jplot2d.swing.proptable.editor.FloatArrayEditor;
import org.jplot2d.swing.proptable.editor.FloatEditor;
import org.jplot2d.swing.proptable.editor.FontPropertyEditor;
import org.jplot2d.swing.proptable.editor.IntegerEditor;
import org.jplot2d.swing.proptable.editor.LongEditor;
import org.jplot2d.swing.proptable.editor.PropertyEditorFactory;
import org.jplot2d.swing.proptable.editor.StringPropertyEditor;
import org.jplot2d.swing.proptable.property.Property;

public class PropertyEditorRegistry
implements PropertyEditorFactory {
    private Map<Class<?>, PropertyEditor> typeEditorMap = new HashMap();

    public PropertyEditorRegistry() {
        this.registerDefaults();
    }

    public void registerEditor(Class<?> type, PropertyEditor renderer) {
        this.typeEditorMap.put(type, renderer);
    }

    public void unregisterEditor(Class<?> type) {
        this.typeEditorMap.remove(type);
    }

    @Override
    public PropertyEditor createPropertyEditor(Property<?> property) {
        Object[] avs = property.getAvailableValues();
        if (avs != null) {
            return new ComboBoxPropertyEditor(avs);
        }
        Class<?> propType = property.getType();
        if (Enum.class.isAssignableFrom(propType)) {
            return new EnumPropertyEditor(propType);
        }
        return this.typeEditorMap.get(propType);
    }

    public void registerDefaults() {
        this.typeEditorMap.clear();
        DoubleEditor doubleEditor = new DoubleEditor();
        this.registerEditor(Double.TYPE, doubleEditor);
        this.registerEditor(Double.class, doubleEditor);
        FloatEditor floatEditor = new FloatEditor();
        this.registerEditor(Float.TYPE, floatEditor);
        this.registerEditor(Float.class, floatEditor);
        LongEditor longEditor = new LongEditor();
        this.registerEditor(Long.TYPE, longEditor);
        this.registerEditor(Long.class, longEditor);
        IntegerEditor integerEditor = new IntegerEditor();
        this.registerEditor(Integer.TYPE, integerEditor);
        this.registerEditor(Integer.class, integerEditor);
        BooleanPropertyEditor booleanEditor = new BooleanPropertyEditor();
        this.registerEditor(Boolean.TYPE, booleanEditor);
        this.registerEditor(Boolean.class, booleanEditor);
        this.registerEditor(float[].class, new FloatArrayEditor());
        this.registerEditor(double[].class, new DoubleArrayEditor());
        this.registerEditor(String.class, new StringPropertyEditor());
        this.registerEditor(Color.class, new ColorPropertyEditor());
        this.registerEditor(Font.class, new FontPropertyEditor());
    }
}

