/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooserDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private boolean OK;
    private Font fontValue;
    private JButton btnOK;
    private JButton btnCancel;
    private JScrollPane jScrollPane3;
    private JLabel sizeLabel;
    private JScrollPane jScrollPane2;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JList familyList;
    private JScrollPane jScrollPane1;
    private JTextField txtFamily;
    private JLabel fontLabel;
    private JList lstStyle;
    private JTextField txtStyle;
    private JLabel styleLabel;
    private JTextField txtSize;
    private JList lstSize;

    public FontChooserDialog(Window parent, boolean modal) {
        super(parent);
        this.setModal(modal);
        this.initComponents();
    }

    public boolean isOK() {
        return this.OK;
    }

    public Font getFontValue() {
        return this.fontValue;
    }

    public void setFontValue(Font f) {
        if (f != null) {
            this.txtFamily.setText(f.getFamily());
            this.familyList.setSelectedValue(f.getFamily(), true);
            String style = "Plain";
            switch (f.getStyle()) {
                case 0: {
                    style = "Plain";
                    break;
                }
                case 1: {
                    style = "Bold";
                    break;
                }
                case 2: {
                    style = "Italic";
                    break;
                }
                case 3: {
                    style = "Bold Italic";
                }
            }
            this.txtStyle.setText(style);
            this.lstStyle.setSelectedValue(style, true);
            this.txtSize.setText("" + f.getSize());
            this.lstSize.setSelectedValue(f.getSize(), true);
            this.previewLabel.setFont(f);
            this.previewLabel.setText(f.getFamily() + " " + f.getSize() + " " + style);
        }
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Choose Font");
        this.setModal(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.getJScrollPane1()).addComponent(this.getFamilyLabel()).addComponent(this.getTxtFamily())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.getJScrollPane2()).addComponent(this.getStyleLabel()).addComponent(this.getTxtStyle())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.getJScrollPane3()).addComponent(this.getSizeLabel()).addComponent(this.getTxtSize()))).addComponent(this.getPreviewPanel()).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getBtnOK()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getBtnCancel()))).addContainerGap());
        layout.linkSize(0, this.btnCancel, this.btnOK);
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getFamilyLabel()).addComponent(this.getStyleLabel()).addComponent(this.getSizeLabel())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getTxtStyle()).addComponent(this.getTxtFamily()).addComponent(this.getTxtSize())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.getJScrollPane2()).addComponent(this.getJScrollPane1()).addComponent(this.getJScrollPane3())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getPreviewPanel()).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getBtnCancel()).addComponent(this.getBtnOK())).addContainerGap());
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.OK = false;
        this.dispose();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        String family = this.txtFamily.getText();
        if (family.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please choose a font family!", "Error", 0);
            return;
        }
        String style = this.txtStyle.getText();
        if (style.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please choose a font style!", "Error", 0);
            return;
        }
        String size = this.txtSize.getText();
        if (size.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please choose a font size!", "Error", 0);
            return;
        }
        try {
            int isize = Integer.parseInt(size);
            if (isize < 3) {
                JOptionPane.showMessageDialog(this, "Font size should be an integer bigger than 2!", "Error", 0);
                return;
            }
            int istyle = 0;
            if (style.equals("Plain")) {
                istyle = 0;
            } else if (style.equals("Bold")) {
                istyle = 1;
            } else if (style.equals("Italic")) {
                istyle = 2;
            } else if (style.equals("Bold Italic")) {
                istyle = 3;
            }
            this.OK = true;
            this.fontValue = new Font(family, istyle, isize);
            this.dispose();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Font size should be an integer!", "Error", 0);
        }
    }

    private void lstFamilyValueChanged(ListSelectionEvent evt) {
        String family = (String)this.familyList.getSelectedValue();
        this.txtFamily.setText(family);
        this.refreshPreview();
    }

    private void lstStyleValueChanged(ListSelectionEvent evt) {
        String style = (String)this.lstStyle.getSelectedValue();
        this.txtStyle.setText(style);
        this.refreshPreview();
    }

    private void lstSizeValueChanged(ListSelectionEvent evt) {
        String size = ((Integer)this.lstSize.getSelectedValue()).toString();
        this.txtSize.setText(size);
        this.refreshPreview();
    }

    private void txtSizeActionPerformed(ActionEvent evt) {
        String tSize = this.txtSize.getText();
        try {
            int size = Integer.parseInt(tSize);
            if (size < 3) {
                JOptionPane.showMessageDialog(this, "Font size should be an integer bigger than 2!", "Error", 0);
                return;
            }
            this.lstSize.setSelectedValue(size, true);
            this.refreshPreview();
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "Font size should be an integer!", "Error", 0);
        }
    }

    private void refreshPreview() {
        String family = this.txtFamily.getText();
        if (family.trim().length() == 0) {
            return;
        }
        String style = this.txtStyle.getText();
        if (style.trim().length() == 0) {
            return;
        }
        String size = this.txtSize.getText();
        if (size.trim().length() == 0) {
            return;
        }
        try {
            int isize = Integer.parseInt(size);
            if (isize < 3) {
                return;
            }
            int istyle = 0;
            if (style.equals("Plain")) {
                istyle = 0;
            } else if (style.equals("Bold")) {
                istyle = 1;
            } else if (style.equals("Italic")) {
                istyle = 2;
            } else if (style.equals("Bold Italic")) {
                istyle = 3;
            }
            Font f = new Font(family, istyle, isize);
            this.previewLabel.setFont(f);
            this.previewLabel.setText(f.getFamily() + " " + f.getSize() + " " + style);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setText("OK");
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FontChooserDialog.this.btnOKActionPerformed(evt);
                }
            });
        }
        return this.btnOK;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FontChooserDialog.this.btnCancelActionPerformed(evt);
                }
            });
        }
        return this.btnCancel;
    }

    private JScrollPane getJScrollPane3() {
        if (this.jScrollPane3 == null) {
            this.jScrollPane3 = new JScrollPane();
            this.jScrollPane3.setViewportView(this.getLstSize());
        }
        return this.jScrollPane3;
    }

    private JList getLstSize() {
        if (this.lstSize == null) {
            this.lstSize = new JList(new FontSizeListModel());
            this.lstSize.setSelectionMode(0);
            this.lstSize.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    FontChooserDialog.this.lstSizeValueChanged(evt);
                }
            });
        }
        return this.lstSize;
    }

    private JLabel getSizeLabel() {
        if (this.sizeLabel == null) {
            this.sizeLabel = new JLabel();
            this.sizeLabel.setText("Size:");
        }
        return this.sizeLabel;
    }

    private JTextField getTxtSize() {
        if (this.txtSize == null) {
            this.txtSize = new JTextField();
            this.txtSize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FontChooserDialog.this.txtSizeActionPerformed(evt);
                }
            });
        }
        return this.txtSize;
    }

    private JLabel getStyleLabel() {
        if (this.styleLabel == null) {
            this.styleLabel = new JLabel();
            this.styleLabel.setText("Style:");
        }
        return this.styleLabel;
    }

    private JTextField getTxtStyle() {
        if (this.txtStyle == null) {
            this.txtStyle = new JTextField();
            this.txtStyle.setEditable(false);
        }
        return this.txtStyle;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getLstStyle());
        }
        return this.jScrollPane2;
    }

    private JList getLstStyle() {
        if (this.lstStyle == null) {
            this.lstStyle = new JList(new FontStyleListModel());
            this.lstStyle.setSelectionMode(0);
            this.lstStyle.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    FontChooserDialog.this.lstStyleValueChanged(evt);
                }
            });
        }
        return this.lstStyle;
    }

    private JLabel getFamilyLabel() {
        if (this.fontLabel == null) {
            this.fontLabel = new JLabel();
            this.fontLabel.setText("Font:");
        }
        return this.fontLabel;
    }

    private JTextField getTxtFamily() {
        if (this.txtFamily == null) {
            this.txtFamily = new JTextField();
            this.txtFamily.setEditable(false);
        }
        return this.txtFamily;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getLstFamily());
        }
        return this.jScrollPane1;
    }

    private JList getLstFamily() {
        if (this.familyList == null) {
            this.familyList = new JList(new FontFamilyListModel());
            this.familyList.setSelectionMode(0);
            this.familyList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    FontChooserDialog.this.lstFamilyValueChanged(evt);
                }
            });
        }
        return this.familyList;
    }

    private JPanel getPreviewPanel() {
        if (this.previewPanel == null) {
            this.previewPanel = new JPanel();
            this.previewPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
            this.previewPanel.setLayout(new BorderLayout());
            this.previewPanel.add((Component)this.getPreviewLabel(), "Center");
        }
        return this.previewPanel;
    }

    private JLabel getPreviewLabel() {
        if (this.previewLabel == null) {
            this.previewLabel = new JLabel();
            this.previewLabel.setText("Sample Text");
            this.previewLabel.setHorizontalAlignment(0);
        }
        return this.previewLabel;
    }

    private static class FontFamilyListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private List<String> list = new ArrayList<String>();

        private FontFamilyListModel() {
            String[] font_families;
            for (String family_name : font_families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                this.list.add(family_name);
            }
        }

        @Override
        public Object getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }
    }

    private static class FontStyleListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private List<String> list = new ArrayList<String>();

        private FontStyleListModel() {
            this.list.add("Plain");
            this.list.add("Bold");
            this.list.add("Italic");
            this.list.add("Bold Italic");
        }

        @Override
        public Object getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }
    }

    private static class FontSizeListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private List<Integer> sizeList = new ArrayList<Integer>();

        private FontSizeListModel() {
            this.sizeList.add(3);
            this.sizeList.add(5);
            this.sizeList.add(8);
            this.sizeList.add(10);
            this.sizeList.add(12);
            this.sizeList.add(14);
            this.sizeList.add(18);
            this.sizeList.add(24);
            this.sizeList.add(36);
            this.sizeList.add(48);
        }

        @Override
        public Object getElementAt(int index) {
            return this.sizeList.get(index);
        }

        @Override
        public int getSize() {
            return this.sizeList.size();
        }
    }
}

