/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.editor;

import javax.swing.JTextField;
import org.jplot2d.swing.proptable.editor.AbstractPropertyEditor;
import org.jplot2d.util.NumberArrayUtils;

public class FloatArrayEditor
extends AbstractPropertyEditor<JTextField> {
    private float[] oldValue;

    public FloatArrayEditor() {
        this.editor = new JTextField();
        ((JTextField)this.editor).setBorder(null);
    }

    @Override
    public Object getValue() {
        String text = ((JTextField)this.editor).getText();
        if (text == null || text.length() == 0) {
            return null;
        }
        String[] values = text.split(",");
        float[] result = new float[values.length];
        try {
            for (int i = 0; i < values.length; ++i) {
                result[i] = Float.parseFloat(values[i]);
            }
            return result;
        }
        catch (NumberFormatException e) {
            return this.oldValue;
        }
    }

    @Override
    public void setValue(Object value) {
        this.oldValue = (float[])value;
        if (value == null) {
            ((JTextField)this.editor).setText("");
        } else {
            ((JTextField)this.editor).setText(NumberArrayUtils.toString((float[])value));
        }
    }
}

