/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable;

import org.jplot2d.swing.proptable.PropertyTableModel;
import org.jplot2d.swing.proptable.property.Property;

public class PropertyTableItem {
    private final PropertyTableModel propertyTableModel;
    private String name;
    private Property<?> property;
    private PropertyTableItem parent;
    private boolean hasToggle = true;
    private boolean visible = true;

    PropertyTableItem(PropertyTableModel propertyTableModel, String name, PropertyTableItem parent) {
        this.propertyTableModel = propertyTableModel;
        this.name = name;
        this.parent = parent;
        this.hasToggle = true;
    }

    PropertyTableItem(PropertyTableModel propertyTableModel, Property<?> property, PropertyTableItem parent) {
        this.propertyTableModel = propertyTableModel;
        this.name = property.getDisplayName();
        this.property = property;
        this.parent = parent;
        Property<?>[] subProperties = property.getSubProperties();
        this.hasToggle = subProperties != null && subProperties.length > 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean isProperty() {
        return this.property != null;
    }

    public Property getProperty() {
        return this.property;
    }

    public PropertyTableItem getParent() {
        return this.parent;
    }

    public int getDepth() {
        int depth = 0;
        if (this.parent != null) {
            depth = this.parent.getDepth();
            if (this.parent.isProperty()) {
                ++depth;
            }
        }
        return depth;
    }

    public boolean hasToggle() {
        return this.hasToggle;
    }

    public void toggle() {
        if (this.hasToggle()) {
            this.visible = !this.visible;
            this.propertyTableModel.republish();
        }
    }

    public boolean isVisible() {
        return !(this.parent != null && !this.parent.isVisible() || this.hasToggle && !this.visible);
    }

    public String getToolTipText() {
        if (this.property == null) {
            return "Group " + this.getName();
        }
        return this.property.getShortDescription();
    }
}

