/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jplot2d.swing.proptable.HeaderlessColumnResizer;
import org.jplot2d.swing.proptable.PropertyCellEditor;
import org.jplot2d.swing.proptable.PropertyTableItem;
import org.jplot2d.swing.proptable.PropertyTableModel;
import org.jplot2d.swing.proptable.cellrenderer.TableCellRendererFactory;
import org.jplot2d.swing.proptable.cellrenderer.TableCellRendererRegistry;
import org.jplot2d.swing.proptable.editor.PropertyEditorFactory;
import org.jplot2d.swing.proptable.editor.PropertyEditorRegistry;
import org.jplot2d.swing.proptable.property.Property;

public class PropertyTable
extends JTable {
    private static final int HOTSPOT_SIZE = 18;
    private static final String TREE_EXPANDED_ICON_KEY = "Tree.expandedIcon";
    private static final String TREE_COLLAPSED_ICON_KEY = "Tree.collapsedIcon";
    private static final String PANEL_BACKGROUND_COLOR_KEY = "Panel.background";
    private static final long serialVersionUID = 1L;
    private TableCellRenderer categoryValueRenderer;
    private TableCellRenderer nameRenderer;
    private TableCellRendererFactory rendererFactory;
    private PropertyEditorFactory editorFactory;

    public PropertyTable() {
        super(new PropertyTableModel());
        Dimension nullSize = new Dimension(0, 0);
        this.getTableHeader().setPreferredSize(nullSize);
        this.getTableHeader().setMinimumSize(nullSize);
        this.getTableHeader().setMaximumSize(nullSize);
        this.getTableHeader().setVisible(false);
        new HeaderlessColumnResizer(this);
        this.setGridColor(UIManager.getColor(PANEL_BACKGROUND_COLOR_KEY));
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setFillsViewportHeight(true);
        this.setAutoResizeMode(4);
        this.addMouseListener(new CategoryVisibilityToggle());
        this.nameRenderer = new NameRenderer();
        this.categoryValueRenderer = new CategoryValueRenderer();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setTableCellRendererFactory(new TableCellRendererRegistry());
        this.setEditorFactory(new PropertyEditorRegistry());
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        PropertyTableModel model = this.getModel();
        PropertyTableItem item = model.getPropertyTableItem(row);
        switch (column) {
            case 0: {
                ((JComponent)((Object)this.nameRenderer)).setToolTipText(item.getToolTipText());
                return this.nameRenderer;
            }
            case 1: {
                if (!item.isProperty()) {
                    return this.categoryValueRenderer;
                }
                Property property = item.getProperty();
                TableCellRenderer renderer = this.getTableCellRendererFactory().createTableCellRenderer(property);
                Class<?> type = this.getWrapperClass(property.getType());
                if (renderer == null) {
                    renderer = this.getDefaultRenderer(type);
                }
                if (renderer instanceof JCheckBox) {
                    ((JCheckBox)((Object)renderer)).setHorizontalAlignment(2);
                    ((JCheckBox)((Object)renderer)).setEnabled(property.isEditable());
                }
                return renderer;
            }
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 0) {
            return null;
        }
        PropertyTableItem item = this.getModel().getPropertyTableItem(row);
        if (!item.isProperty()) {
            return null;
        }
        Property property = item.getProperty();
        PropertyEditor editor = this.getEditorFactory().createPropertyEditor(property);
        if (editor != null) {
            return new PropertyCellEditor(editor);
        }
        return null;
    }

    @Override
    public PropertyTableModel getModel() {
        return (PropertyTableModel)super.getModel();
    }

    public void setTableCellRendererFactory(TableCellRendererFactory factory) {
        this.rendererFactory = factory;
    }

    public TableCellRendererFactory getTableCellRendererFactory() {
        return this.rendererFactory;
    }

    public void setEditorFactory(PropertyEditorFactory factory) {
        this.editorFactory = factory;
    }

    public final PropertyEditorFactory getEditorFactory() {
        return this.editorFactory;
    }

    static int getIndent(PropertyTableItem item) {
        int indent = 0;
        if (item.isProperty()) {
            indent = (item.getParent() == null || !item.getParent().isProperty()) && !item.hasToggle() ? 18 : (item.hasToggle() ? item.getDepth() * 18 : (item.getDepth() + 1) * 18);
            indent += 18;
        } else {
            indent = 0;
        }
        return indent;
    }

    @Override
    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        this.setDefaultRenderer(Float.class, null);
        this.setDefaultRenderer(Double.class, null);
    }

    private Class<?> getWrapperClass(Class<?> primitive) {
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        return primitive;
    }

    private static class CategoryVisibilityToggle
    extends MouseAdapter {
        private CategoryVisibilityToggle() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            PropertyTable table = (PropertyTable)event.getComponent();
            int row = table.rowAtPoint(event.getPoint());
            int column = table.columnAtPoint(event.getPoint());
            if (row != -1 && column == 0) {
                PropertyTableItem item = table.getModel().getPropertyTableItem(row);
                int x = event.getX() - PropertyTable.getIndent(item);
                if (x > 0 && x < 18) {
                    item.toggle();
                }
            }
        }
    }

    private static class CategoryValueRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private CategoryValueRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getGridColor());
                this.setForeground(table.getGridColor().darker());
            }
            this.setText("");
            return this;
        }
    }

    private static class NameRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private CellBorder border = new CellBorder();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(this.border);
            PropertyTableItem item = (PropertyTableItem)value;
            this.border.configure((PropertyTable)table, item);
            if (item.isProperty()) {
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(table.getSelectionForeground());
                } else {
                    this.setBackground(table.getBackground());
                    this.setForeground(table.getForeground());
                }
            } else if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getGridColor());
                this.setForeground(table.getGridColor().darker());
            }
            this.setEnabled(isSelected || !item.isProperty() ? true : item.getProperty().isEditable());
            this.setFont(this.getFont().deriveFont(item.isProperty() ? 0 : 1));
            this.setText(item.getName());
            return this;
        }
    }

    private static class CellBorder
    implements Border {
        private int indentWidth;
        private boolean showToggle;
        private boolean toggleState;
        private Color bgColor;
        private Icon expandedIcon = (Icon)UIManager.get("Tree.expandedIcon");
        private Icon collapsedIcon = (Icon)UIManager.get("Tree.collapsedIcon");
        private Insets insets = new Insets(1, 0, 1, 1);
        private boolean isProperty;

        private CellBorder() {
        }

        public void configure(PropertyTable table, PropertyTableItem item) {
            this.isProperty = item.isProperty();
            this.toggleState = item.isVisible();
            this.showToggle = item.hasToggle();
            if (!this.isProperty) {
                this.bgColor = table.getGridColor();
            }
            this.indentWidth = PropertyTable.getIndent(item);
            this.insets.left = this.indentWidth + (this.showToggle ? 18 : 0) + 2;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!this.isProperty) {
                Color oldColor = g.getColor();
                g.setColor(this.bgColor);
                g.fillRect(x, y, x + 18 - 2, y + height);
                g.setColor(oldColor);
            }
            if (this.showToggle) {
                Icon drawIcon = this.toggleState ? this.expandedIcon : this.collapsedIcon;
                drawIcon.paintIcon(c, g, x + this.indentWidth + (16 - drawIcon.getIconWidth()) / 2, y + (height - drawIcon.getIconHeight()) / 2);
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

