/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.outline;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jplot2d.element.Element;
import org.jplot2d.swing.outline.PlotTreeModel;

public class PlotTree
extends JTree {
    private static final long serialVersionUID = 1L;

    public PlotTree(PlotTreeModel model) {
        super(model);
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof Element) {
            return ((Element)value).getId();
        }
        return "Unknown";
    }

    public void expandAll(TreePath path) {
        this.expandAll(path, -1);
    }

    public void expandAll(TreePath path, int depth) {
        if (depth == 0) {
            this.collapsePath(path);
            return;
        }
        Object parent = path.getLastPathComponent();
        if (this.getModel().isLeaf(parent)) {
            return;
        }
        this.expandPath(path);
        --depth;
        int size = this.getModel().getChildCount(parent);
        for (int i = 0; i < size; ++i) {
            Object child = this.getModel().getChild(parent, i);
            this.expandAll(path.pathByAddingChild(child), depth);
        }
    }

    public void expandAll(TreePath path, Class<?> clazz) {
        Object parent = path.getLastPathComponent();
        if (clazz.isAssignableFrom(parent.getClass())) {
            this.expandPath(path);
        }
        int size = this.getModel().getChildCount(parent);
        for (int i = 0; i < size; ++i) {
            Object child = this.getModel().getChild(parent, i);
            this.expandAll(path.pathByAddingChild(child), clazz);
        }
    }
}

