/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.outline;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jplot2d.element.Element;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.env.ElementChangeEvent;
import org.jplot2d.env.ElementChangeListener;
import org.jplot2d.env.PlotEnvironment;
import org.jplot2d.swing.components.ShowPropertiesAction;
import org.jplot2d.swing.outline.PlotTree;
import org.jplot2d.swing.outline.PlotTreeModel;

public class PlotOutline
implements ElementChangeListener {
    private final Plot _plot;
    private final PlotTreeModel _treeModel;
    private final PlotTree _plotTree;
    private boolean _modified;
    private ShowPropertiesAction _showPropertiesAction;

    public PlotOutline(PlotEnvironment env) {
        this._plot = env.getPlot();
        this._treeModel = new PlotTreeModel(this._plot);
        this._plotTree = new PlotTree(this._treeModel);
        this._plotTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath newPath = e.getNewLeadSelectionPath();
                PlotOutline.this.triggerShowPanel(newPath);
            }
        });
        this._plotTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PlotOutline.this.showPopupMenu(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PlotOutline.this.showPopupMenu(e.getPoint());
                }
            }
        });
        this._plotTree.expandAll(new TreePath(this._treeModel.getRoot()), Plot.class);
        env.addElementChangeListener(this);
    }

    public JComponent getComponent() {
        return this._plotTree;
    }

    @Override
    public void componentAdded(final ElementChangeEvent evt) {
        this._modified = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlotOutline.this._treeModel.fireTreeStructureChanged(evt.getElement());
            }
        });
    }

    @Override
    public void componentRemoving(ElementChangeEvent evt) {
    }

    @Override
    public void componentRemoved(final ElementChangeEvent evt) {
        this._modified = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlotOutline.this._treeModel.fireTreeStructureChanged(evt.getElement());
            }
        });
    }

    @Override
    public void propertiesChanged(ElementChangeEvent evt) {
        this._modified = true;
    }

    @Override
    public void propertyChangesProcessed(ElementChangeEvent evt) {
        if (this._modified) {
            this._modified = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreePath path = PlotOutline.this._plotTree.getSelectionPath();
                    if (path != null) {
                        PlotOutline.this.triggerShowPanel(path);
                    }
                }
            });
        }
    }

    private void showPopupMenu(Point point) {
        final TreePath path = this._plotTree.getSelectionPath();
        if (path == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        Object pe = path.getLastPathComponent();
        if (pe instanceof Layer) {
            JMenuItem itemRemove = new JMenuItem("Remove");
            itemRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotOutline.this.removeLayer(path);
                }
            });
            popup.add(itemRemove);
        }
        popup.show(this._plotTree, point.x, point.y);
    }

    private void removeLayer(TreePath path) {
        Plot plot = (Plot)((Object)path.getParentPath());
        Layer layer = (Layer)path.getLastPathComponent();
        plot.removeLayer(layer);
    }

    private void triggerShowPanel(TreePath path) {
        Element newNode = path == null ? null : (Element)path.getLastPathComponent();
        this._showPropertiesAction.triggerShowProperties(newNode);
    }

    public void setShowPropertiesAction(ShowPropertiesAction action) {
        this._showPropertiesAction = action;
    }

    public void showCurrentProperties() {
        TreePath path = this._plotTree.getSelectionPath();
        this.triggerShowPanel(path);
    }
}

