/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.interaction;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Shape;
import java.awt.SystemColor;
import javax.swing.SwingUtilities;
import org.jplot2d.env.RenderEnvironment;
import org.jplot2d.interaction.InteractiveComp;
import org.jplot2d.swing.JPlot2DComponent;

public class SwingInteractiveComp
implements InteractiveComp {
    private final JPlot2DComponent comp;
    private InteractiveComp.CursorStyle cursorStyle;

    public SwingInteractiveComp(JPlot2DComponent comp, RenderEnvironment env) {
        this.comp = comp;
    }

    @Override
    public Point getCursorLocation() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, this.comp);
        p.x -= this.comp.getImageOffsetX();
        p.y -= this.comp.getImageOffsetY();
        return p;
    }

    @Override
    public void repaint() {
        this.comp.repaint();
    }

    @Override
    public InteractiveComp.CursorStyle getCursor() {
        return this.cursorStyle;
    }

    @Override
    public void setCursor(InteractiveComp.CursorStyle cursorStyle) {
        this.cursorStyle = cursorStyle;
        switch (cursorStyle) {
            case DEFAULT_CURSOR: {
                this.comp.setCursor(Cursor.getPredefinedCursor(0));
                break;
            }
            case MOVE_CURSOR: {
                this.comp.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case CROSSHAIR_CURSOR: {
                this.comp.setCursor(Cursor.getPredefinedCursor(1));
            }
        }
    }

    @Override
    public void drawLine(Object g, int rgb, int x1, int y1, int x2, int y2) {
        Graphics2D g2 = (Graphics2D)g;
        Color c = new Color(rgb);
        g2.setColor(c);
        g2.setXORMode(this.comp.getPlotBackground());
        g2.drawLine(x1 + this.comp.getImageOffsetX(), y1 + this.comp.getImageOffsetY(), x2 + this.comp.getImageOffsetX(), y2 + this.comp.getImageOffsetY());
        g2.setPaintMode();
    }

    @Override
    public void drawRectangle(Object g, int rgb, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        Color c = new Color(rgb);
        g2.setColor(c);
        g2.setXORMode(this.comp.getPlotBackground());
        g2.drawRect(x + this.comp.getImageOffsetX(), y + this.comp.getImageOffsetY(), width, height);
        g2.setPaintMode();
    }

    @Override
    public void drawShape(Object g, int rgb, Shape shape) {
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(this.comp.getImageOffsetX(), this.comp.getImageOffsetY());
        Color c = new Color(rgb);
        g2.setColor(c);
        g2.setXORMode(this.comp.getPlotBackground());
        g2.draw(shape);
        g2.setPaintMode();
        g2.translate(-this.comp.getImageOffsetX(), -this.comp.getImageOffsetY());
    }

    @Override
    public void drawTooltip(Object g, String s, int x, int y) {
        x += this.comp.getImageOffsetX() + 4;
        y += this.comp.getImageOffsetY() + 2;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(SystemColor.infoText);
        g2.setBackground(SystemColor.info);
        y += g2.getFontMetrics().getAscent();
        int cridx = s.indexOf(10);
        if (cridx == -1) {
            g2.drawString(s, x, y);
        } else {
            String sa = s.substring(0, cridx);
            g2.drawString(sa, x, y);
            String sb = s.substring(cridx + 1);
            g2.drawString(sb, x, y += g2.getFontMetrics().getHeight());
        }
    }
}

