/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.components;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.jplot2d.element.Element;
import org.jplot2d.env.InterfaceInfo;
import org.jplot2d.env.PlotEnvironment;
import org.jplot2d.swing.components.ShowPropertiesAction;
import org.jplot2d.swing.outline.PlotOutline;
import org.jplot2d.swing.proptable.ProperiesModel;
import org.jplot2d.swing.proptable.PropertyTable;
import org.jplot2d.swing.proptable.PropertyTableModel;

public class PlotPropertiesFrame
extends JFrame
implements ShowPropertiesAction {
    private static final long serialVersionUID = 1L;
    private final PlotOutline _manager;
    private JSplitPane splitPane;
    private JScrollPane scrollPaneL;
    private JScrollPane scrollPaneR;
    private PropertyTable _propertyTable;

    public PlotPropertiesFrame(PlotEnvironment env) {
        super("Properties Panel");
        this._manager = new PlotOutline(env);
        this._manager.setShowPropertiesAction(this);
        this.initGUI();
    }

    private void initGUI() {
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.getTreeTablePanel(), "Center");
        this.pack();
    }

    private JSplitPane getTreeTablePanel() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.splitPane.setOrientation(1);
            this.scrollPaneL = new JScrollPane();
            this.scrollPaneR = new JScrollPane();
            this.splitPane.add((Component)this.scrollPaneL, "left");
            this.splitPane.add((Component)this.scrollPaneR, "right");
            this.scrollPaneL.getViewport().add(this.getPlotTree());
            this.scrollPaneR.getViewport().add(this.getPropTable());
        }
        return this.splitPane;
    }

    private Component getPlotTree() {
        return this._manager.getComponent();
    }

    private Component getPropTable() {
        if (this._propertyTable == null) {
            this._propertyTable = new PropertyTable();
        }
        return this._propertyTable;
    }

    @Override
    public void triggerShowProperties(Element element) {
        Element engine = element;
        if (engine == this._propertyTable.getModel().getEngine()) {
            this._propertyTable.getModel().refresh();
        } else if (engine == null) {
            PropertyTableModel tableModel = new PropertyTableModel(null, null);
            this._propertyTable.setModel(tableModel);
        } else {
            Class<?> cls = engine.getClass().getInterfaces()[0];
            ProperiesModel model = new ProperiesModel(InterfaceInfo.loadInterfaceInfo(cls).getPropertyInfoGroupMap());
            PropertyTableModel tableModel = new PropertyTableModel(engine, model);
            tableModel.setDialogParent(this._propertyTable);
            this._propertyTable.setModel(tableModel);
        }
    }
}

