/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.swing.JPanel;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.renderer.CacheableBlock;
import org.jplot2d.renderer.Renderer;

public class VectorGraphicsExporter
extends Renderer {
    private final OutputStream os;

    public VectorGraphicsExporter(String pathname) throws FileNotFoundException {
        this(new File(pathname));
    }

    public VectorGraphicsExporter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public VectorGraphicsExporter(OutputStream out) {
        this.os = new BufferedOutputStream(out);
    }

    @Override
    public void render(ComponentEx comp, List<CacheableBlock> cacheBlockList) {
        Dimension size = VectorGraphicsExporter.getDeviceBounds(comp).getSize();
        Document document = new Document(new Rectangle((float)size.width, (float)size.height), 0.0f, 0.0f, 0.0f, 0.0f);
        Properties properties = new Properties();
        properties.setProperty("PageSize", "A5");
        JPanel jp = new JPanel();
        jp.setPreferredSize(size);
    }
}

