/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.notice;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jplot2d.notice.AbstractNotifier;
import org.jplot2d.notice.LoggingNotifier;
import org.jplot2d.notice.Notice;
import org.jplot2d.notice.NoticeType;
import org.jplot2d.notice.UINoticeType;

public class DefaultNotifier
extends AbstractNotifier {
    private final Component plotComp;

    public DefaultNotifier(Component plotComp) {
        this.plotComp = plotComp;
    }

    @Override
    public void showNotices(NoticeType type) {
        if (this.notices.size() == 0) {
            return;
        }
        if (type instanceof UINoticeType) {
            final StringBuilder sb = new StringBuilder();
            for (Notice wm : this.notices) {
                sb.append(wm.getMessage());
                sb.append("\n");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(DefaultNotifier.this.plotComp, sb, "Warning", 2);
                }
            });
        } else {
            LoggingNotifier.logNotices(this.notices.toArray(new Notice[this.notices.size()]));
        }
    }
}

