/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.layout;

import org.jplot2d.util.SparseDoubleArray;

public class GridCellGeom {
    private final SparseDoubleArray colWidth;
    private final SparseDoubleArray rowHeight;
    private final double sumWidth;
    private final double sumHeight;

    public GridCellGeom(SparseDoubleArray colWidth, SparseDoubleArray rowHeight) {
        int i;
        this.colWidth = colWidth;
        this.rowHeight = rowHeight;
        double sw = 0.0;
        double sh = 0.0;
        for (i = 0; i < colWidth.size(); ++i) {
            double w = colWidth.valueAt(i);
            sw += w;
        }
        for (i = 0; i < rowHeight.size(); ++i) {
            double h = rowHeight.valueAt(i);
            sh += h;
        }
        this.sumWidth = sw;
        this.sumHeight = sh;
    }

    public double getWidth(int col) {
        return this.colWidth.get(col);
    }

    public double getHeight(int row) {
        return this.rowHeight.get(row);
    }

    public double getSumWidthLeft(int col) {
        double sum = 0.0;
        for (int i = 0; i < this.colWidth.size(); ++i) {
            int c = this.colWidth.keyAt(i);
            double v = this.colWidth.valueAt(i);
            if (c >= col) continue;
            sum += v;
        }
        return sum;
    }

    public double getSumHeightBelow(int row) {
        double sum = 0.0;
        for (int i = 0; i < this.rowHeight.size(); ++i) {
            int r = this.rowHeight.keyAt(i);
            double v = this.rowHeight.valueAt(i);
            if (r >= row) continue;
            sum += v;
        }
        return sum;
    }

    public double getSumWidth() {
        return this.sumWidth;
    }

    public double getSumHeight() {
        return this.sumHeight;
    }

    public int getRowNum() {
        return this.rowHeight.size();
    }

    public int getColNum() {
        return this.colWidth.size();
    }
}

